<?php
require __DIR__ . '/header.php';
require_once dirname(__DIR__) . '/include/functions.php';
xoops_loadLanguage('admin', 'sondages_pro');


$mid = 0;
if (isset($GLOBALS['xoopsModule']) && is_object($GLOBALS['xoopsModule']) && $GLOBALS['xoopsModule']->getVar('dirname') === 'sondages_pro') {
    $mid = (int)$GLOBALS['xoopsModule']->getVar('mid');
}
if ($mid <= 0) {
    $moduleHandler = xoops_getHandler('module');
    $mod = $moduleHandler->getByDirname('sondages_pro');
    if ($mod) { $mid = (int)$mod->getVar('mid'); }
}
if ($mid <= 0) {
    redirect_header('index.php', 3, _AM_SYSTEM_DBERROR);
    exit;
}

$memberHandler = xoops_getHandler('member');
$gpermHandler  = xoops_getHandler('groupperm');
$groups        = $memberHandler->getGroups();

// --- Enregistrement ---
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST' && isset($_POST['op']) && $_POST['op'] === 'save') {
    if (!$GLOBALS['xoopsSecurity']->check()) {
        redirect_header('permissions.php', 3, _NOPERM);
        exit;
    }

    // Récup des cases cochées (tableaux d'IDs de groupes)
    $sel_view   = array_map('intval', (array)($_POST['sp_view'] ?? []));
    $sel_vote   = array_map('intval', (array)($_POST['sp_vote'] ?? []));
    $sel_create = array_map('intval', (array)($_POST['sp_create'] ?? []));


    if (method_exists($gpermHandler, 'deleteByModule')) {
        $gpermHandler->deleteByModule($mid, 'sp_view',   0);
        $gpermHandler->deleteByModule($mid, 'sp_vote',   0);
        $gpermHandler->deleteByModule($mid, 'sp_create', 0);
    } else {

        $db = XoopsDatabaseFactory::getDatabaseConnection();
        $db->queryF("DELETE FROM ".$db->prefix("group_permission")." WHERE gperm_modid=".$mid." AND gperm_itemid=0 AND gperm_name IN ('sp_view','sp_vote','sp_create')");
    }


    foreach ($sel_view as $gid)   { $gpermHandler->addRight('sp_view',   0, $gid, $mid); }
    foreach ($sel_vote as $gid)   { $gpermHandler->addRight('sp_vote',   0, $gid, $mid); }
    foreach ($sel_create as $gid) { $gpermHandler->addRight('sp_create', 0, $gid, $mid); }

    redirect_header('permissions.php', 2, _AM_SP_SAVED);
    exit;
}

// --- Pré-remplissage des cases ---
$pre_view = $pre_vote = $pre_create = [];
foreach ($groups as $g) {
    $gid = (int)$g->getVar('groupid');
    $pre_view[$gid]   = $gpermHandler->checkRight('sp_view',   0, $gid, $mid) ? 1 : 0;
    $pre_vote[$gid]   = $gpermHandler->checkRight('sp_vote',   0, $gid, $mid) ? 1 : 0;
    $pre_create[$gid] = $gpermHandler->checkRight('sp_create', 0, $gid, $mid) ? 1 : 0;
}

// --- Rendu ---
echo '<h2>'._AM_SP_TITLE.' — '._AM_SP_PERMISSIONS.'</h2>';
echo '<p>'._AM_SP_PERMISSIONS_DESC.'</p>';

echo '<form method="post" action="permissions.php">';
echo '<input type="hidden" name="XOOPS_TOKEN_REQUEST" value="'.$GLOBALS['xoopsSecurity']->createToken().'" />';
echo '<input type="hidden" name="op" value="save" />';

echo '<table class="outer" cellspacing="1" cellpadding="4">';
echo '<tr class="head"><th>Groupe</th><th>'._AM_SP_PERM_VIEW.'</th><th>'._AM_SP_PERM_VOTE.'</th><th>'._AM_SP_PERM_CREATE.'</th></tr>';

$i = 0;
foreach ($groups as $g) {
    $row = ($i++ % 2) ? 'odd':'even';
    $gid = (int)$g->getVar('groupid');
    $name = htmlspecialchars($g->getVar('name'), ENT_QUOTES);

    $chkV = $pre_view[$gid]   ? ' checked' : '';
    $chkT = $pre_vote[$gid]   ? ' checked' : '';
    $chkC = $pre_create[$gid] ? ' checked' : '';

    echo '<tr class="'.$row.'">';
    echo '<td>'.$name.'</td>';
    echo '<td style="text-align:center"><input type="checkbox" name="sp_view[]" value="'.$gid.'"'.$chkV.'></td>';
    echo '<td style="text-align:center"><input type="checkbox" name="sp_vote[]" value="'.$gid.'"'.$chkT.'></td>';
    echo '<td style="text-align:center"><input type="checkbox" name="sp_create[]" value="'.$gid.'"'.$chkC.'></td>';
    echo '</tr>';
}
echo '</table>';

echo '<p style="margin-top:1rem;"><button type="submit" class="formButton">'._AM_SP_SAVE.'</button></p>';
echo '</form>';

xoops_cp_footer();

