<?php
declare(strict_types=1);

require __DIR__ . '/header.php';
xoops_loadLanguage('admin', 'sondages_pro');

// --- Sécurité admin module
if (!is_object($GLOBALS['xoopsUser']) || !$GLOBALS['xoopsUser']->isAdmin($GLOBALS['xoopsModule']->getVar('mid'))) {
    redirect_header('poll.php', 3, defined('_NOPERM') ? _NOPERM : 'Accès refusé.');
    exit;
}


$pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
$optHandler  = xoops_getModuleHandler('option', 'sondages_pro');
$voteHandler = xoops_getModuleHandler('vote', 'sondages_pro');

$op = $_REQUEST['op'] ?? 'list';

function sp_admin_header(): void {
    echo '<h2>' . _AM_SP_TITLE . ' — ' . _AM_SP_POLLS . '</h2>';
    echo '<p><a class="button" href="poll.php?op=new">' . _AM_SP_NEW . '</a></p>';
}

/** =========================
 *  Action: changer le statut
 *  ========================= */
if ($op === 'status') {
    $pollId = (int)($_GET['poll_id'] ?? 0);
    $new    = $_GET['val'] ?? 'published';
    $token  = $_GET['XOOPS_TOKEN_REQUEST'] ?? '';

    if (!in_array($new, ['draft','published','closed'], true) || !$GLOBALS['xoopsSecurity']->validateToken($token, false)) {
        redirect_header('poll.php', 3, defined('_NOPERM') ? _NOPERM : 'Accès refusé.');
        exit;
    }

    $poll = $pollHandler->get($pollId);
    if (!$poll) {
        $msg = defined('_AM_SYSTEM_DBERROR') ? _AM_SYSTEM_DBERROR : 'Erreur de base de données.';
        redirect_header('poll.php', 3, $msg);
        exit;
    }

    $poll->setVar('status', $new);
    $poll->setVar('updated_at', date('Y-m-d H:i:s'));
    $pollHandler->insert($poll);

    redirect_header('poll.php', 2, defined('_AM_SP_SAVED') ? _AM_SP_SAVED : 'Enregistré.');
    exit;
}

/** ==================================
 *  Action: enregistrer (create/update)
 *  ================================== */
if ($op === 'save' && ($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
    if (!$GLOBALS['xoopsSecurity']->check()) {
        redirect_header('poll.php', 3, defined('_NOPERM') ? _NOPERM : 'Accès refusé.');
        exit;
    }

    $pollId = (int)($_POST['poll_id'] ?? 0);
    $isNew  = ($pollId === 0);
    $poll   = $isNew ? $pollHandler->create() : $pollHandler->get($pollId);
    if (!$poll) {
        $msg = defined('_AM_SYSTEM_DBERROR') ? _AM_SYSTEM_DBERROR : 'Erreur de base de données.';
        redirect_header('poll.php', 3, $msg);
        exit;
    }

    // Pas de htmlspecialchars ici : XOOPS gère via getVar('e'/'s') à l'affichage
    $poll->setVar('question',     (string)($_POST['question']     ?? ''));
    $poll->setVar('description',  (string)($_POST['description']  ?? ''));
    $poll->setVar('is_multiple',  isset($_POST['is_multiple']) ? (int)$_POST['is_multiple'] : 0);
    $poll->setVar('max_choices',  max(1, (int)($_POST['max_choices'] ?? 1)));
    $poll->setVar('starts_at',    (string)($_POST['starts_at']    ?? ''));
    $poll->setVar('ends_at',      (string)($_POST['ends_at']      ?? ''));
    $status = $_POST['status'] ?? 'published';
    if (!in_array($status, ['draft','published','closed'], true)) {
        $status = 'published';
    }
    $poll->setVar('status', $status);

    if ($isNew) {
        $poll->setVar('created_by', is_object($GLOBALS['xoopsUser']) ? (int)$GLOBALS['xoopsUser']->getVar('uid') : 0);
        $poll->setVar('created_at', date('Y-m-d H:i:s'));
    } else {
        $poll->setVar('updated_at', date('Y-m-d H:i:s'));
    }

    if ($pollHandler->insert($poll)) {
        $pollId  = (int)$poll->getVar('poll_id');
        $optText = trim((string)($_POST['options_text'] ?? ''));


        // 1) Nettoyage entrée + liste postée (unique insensible à la casse)
        $posted = [];
        if ($optText !== '') {
            foreach (preg_split('/\r?\n/', $optText) as $line) {
                $lab = trim($line);
                if ($lab !== '') $posted[] = $lab;
            }
        }

        // 2) Charger options existantes
        $criteria = new Criteria('poll_id', $pollId);
        $criteria->setSort('sort_order');
        /** @var XoopsObject[] $oldOpts */
        $oldOpts = $optHandler->getObjects($criteria, true); // clé = option_id
        $byLower = []; // lower(label) => optionObj
        foreach ($oldOpts as $opt) {
            $byLower[mb_strtolower((string)$opt->getVar('label'))] = $opt;
        }

        // 3) Upsert : conserver les IDs quand le libellé est (quasi) identique
        $seenIds  = [];
        $seenKeys = [];
        $sort     = 0;

        foreach ($posted as $label) {
            $key = mb_strtolower($label);
            if (isset($seenKeys[$key])) continue; // dédoublonnage
            $seenKeys[$key] = true;

            if (isset($byLower[$key])) {
                // Existe déjà → MAJ ordre, et MAJ libellé si nécessaire (ex: correction accent)
                $opt = $byLower[$key];
                if ($opt->getVar('label') !== $label) {
                    $opt->setVar('label', $label);
                }
                $opt->setVar('sort_order', $sort++);
                $optHandler->insert($opt);
                $seenIds[] = (int)$opt->getVar('option_id');
            } else {
                // Nouvelle option
                $opt = $optHandler->create();
                $opt->setVar('poll_id',    $pollId);
                $opt->setVar('label',      $label);
                $opt->setVar('sort_order', $sort++);
                $optHandler->insert($opt);
                $seenIds[] = (int)$opt->getVar('option_id');
            }
        }

        // 4) Traiter les anciennes non présentes : supprimer si 0 vote, sinon archiver
        foreach ($oldOpts as $optId => $opt) {
            if (in_array((int)$optId, $seenIds, true)) continue;

            $hasVotes = $voteHandler->getCount(new Criteria('option_id', (int)$optId)) > 0;
            if ($hasVotes) {
                // Conserver (ne pas casser les résultats) : suffixe "(archivée)" et pousser en bas
                $label = (string)$opt->getVar('label');
                if (mb_stripos($label, '(archivée)') === false) {
                    $opt->setVar('label', $label . ' (archivée)');
                }
                $opt->setVar('sort_order', 100000); // tout en bas
                $optHandler->insert($opt);
            } else {
                // Aucun vote → suppression réelle
                $optHandler->delete($opt, true);
            }
        }
        // ===== Fin logique OPTIONS =====

        redirect_header('poll.php', 2, defined('_AM_SP_SAVED') ? _AM_SP_SAVED : 'Enregistré.');
    } else {
        $msg = defined('_AM_SYSTEM_DBERROR') ? _AM_SYSTEM_DBERROR : 'Erreur de base de données.';
        redirect_header('poll.php', 3, $msg);
    }
    exit;
}

/** ===================
 *  Action: supprimer
 *  =================== */
if ($op === 'delete') {
    $pollId = (int)($_GET['poll_id'] ?? 0);
    $token  = $_GET['XOOPS_TOKEN_REQUEST'] ?? '';
    if (!$GLOBALS['xoopsSecurity']->validateToken($token, false)) {
        redirect_header('poll.php', 3, defined('_NOPERM') ? _NOPERM : 'Accès refusé.');
        exit;
    }

    $poll = $pollHandler->get($pollId);
    if ($poll) {
        // Supprime d’abord les options (XOOPS ne cascade pas nativement)
        $criteria = new Criteria('poll_id', $pollId);
        foreach ($optHandler->getObjects($criteria) as $o) {
            $optHandler->delete($o, true);
        }
        $pollHandler->delete($poll, true);
        redirect_header('poll.php', 2, defined('_AM_SP_DELETED') ? _AM_SP_DELETED : 'Supprimé.');
    } else {
        $msg = defined('_AM_SYSTEM_DBERROR') ? _AM_SYSTEM_DBERROR : 'Erreur de base de données.';
        redirect_header('poll.php', 3, $msg);
    }
    exit;
}

/** ==========================
 *  Formulaire: nouveau/éditer
 *  ========================== */
if ($op === 'new' || $op === 'edit') {
    $poll    = null;
    $optText = '';

    if ($op === 'edit') {
        $pollId = (int)($_GET['poll_id'] ?? 0);
        $poll   = $pollHandler->get($pollId);
        if (!$poll) {
            $msg = defined('_AM_SYSTEM_DBERROR') ? _AM_SYSTEM_DBERROR : 'Erreur de base de données.';
            redirect_header('poll.php', 3, $msg);
            exit;
        }
        $criteria = new Criteria('poll_id', $pollId);
        $criteria->setSort('sort_order');
        $optsObj = $optHandler->getObjects($criteria);
        $lines   = [];
        foreach ($optsObj as $o) {
            // 'e' pour pré-remplir un textarea (UTF-8, pas de double-échappement)
            $lines[] = $o->getVar('label', 'e');
        }
        $optText = implode("\n", $lines);
    }

    sp_admin_header();
    $title = ($op === 'new') ? _AM_SP_NEW : _AM_SP_EDIT;
    echo '<h3>' . $title . '</h3>';

    echo '<form method="post" action="poll.php?op=save">';
    echo '<input type="hidden" name="XOOPS_TOKEN_REQUEST" value="' . $GLOBALS['xoopsSecurity']->createToken() . '" />';
    echo '<input type="hidden" name="poll_id" value="' . ($poll ? (int)$poll->getVar('poll_id') : 0) . '" />';

    echo '<p><label>' . _AM_SP_QUESTION . '<br>';
    // 'e' = édition (input), 's' = affichage HTML “safe”
    echo '<input type="text" name="question" size="80" value="' . ($poll ? $poll->getVar('question','e') : '') . '" required>';
    echo '</label></p>';

    echo '<p><label>' . _AM_SP_DESCRIPTION . '<br>';
    echo '<textarea name="description" rows="5" cols="80">' . ($poll ? $poll->getVar('description','e') : '') . '</textarea>';
    echo '</label></p>';

    $isMultiple = $poll ? (int)$poll->getVar('is_multiple') : 0;
    echo '<p><label>' . _AM_SP_IS_MULTIPLE . ' ';
    echo '<select name="is_multiple"><option value="0"' . ($isMultiple ? '' : ' selected') . '>Non</option><option value="1"' . ($isMultiple ? ' selected' : '') . '>Oui</option></select>';
    echo '</label></p>';

    $maxChoices = $poll ? (int)$poll->getVar('max_choices') : 1;
    echo '<p><label>' . _AM_SP_MAX_CHOICES . ' ';
    echo '<input type="number" min="1" name="max_choices" value="' . $maxChoices . '">';
    echo '</label></p>';

    echo '<p><label>' . _AM_SP_STARTS_AT . ' ';
    echo '<input type="text" name="starts_at" value="' . ($poll ? $poll->getVar('starts_at','e') : '') . '" placeholder="2025-01-01 00:00:00">';
    echo '</label></p>';

    echo '<p><label>' . _AM_SP_ENDS_AT . ' ';
    echo '<input type="text" name="ends_at" value="' . ($poll ? $poll->getVar('ends_at','e') : '') . '" placeholder="2025-12-31 23:59:59">';
    echo '</label></p>';

    $status = $poll ? (string)$poll->getVar('status') : 'published';
    echo '<p><label>' . _AM_SP_STATUS . ' ';
    echo '<select name="status">';
    foreach (['draft'=>_AM_SP_DRAFT, 'published'=>_AM_SP_PUBLISHED, 'closed'=>_AM_SP_CLOSED] as $k=>$label) {
        $sel = ($status === $k) ? ' selected' : '';
        echo '<option value="' . $k . '"' . $sel . '>' . $label . '</option>';
    }
    echo '</select></label></p>';

    echo '<p><label>' . _AM_SP_OPTIONS . '<br>';
    echo '<textarea name="options_text" rows="8" cols="80">' . $optText . '</textarea>';
    echo '<br><small>Une option par ligne. Les options non ré-énumérées seront <em>archivées</em> si elles ont déjà des votes, sinon supprimées.</small>';
    echo '</label></p>';

    echo '<p><button type="submit">' . _AM_SP_SAVE . '</button> ';
    echo '<a href="poll.php">' . _AM_SP_CANCEL . '</a></p>';

    echo '</form>';
    xoops_cp_footer();
    exit;
}

/** ==========================
 *  Liste (tableau des sondages)
 *  ========================== */
sp_admin_header();

$criteria = new CriteriaCompo();
$criteria->setSort('poll_id');
$criteria->setOrder('DESC');

// On récupère des OBJETS pour pouvoir utiliser getVar('s') proprement
$polls = $pollHandler->getObjects($criteria);

echo '<table class="outer" cellspacing="1" cellpadding="4" style="max-width:980px">';
echo '<tr class="head">';
echo '  <th>ID</th>';
echo '  <th>' . _AM_SP_QUESTION . '</th>';
echo '  <th>' . _AM_SP_STATUS . '</th>';
echo '  <th style="text-align:right">' . _AM_SP_OPTIONS_COUNT . '</th>';
echo '  <th style="text-align:right">' . _AM_SP_VOTES_COUNT . '</th>';
echo '  <th>' . _AM_SP_ACTIONS . '</th>';
echo '</tr>';

if (!empty($polls)) {
    $i = 0;
    foreach ($polls as $p) {
        $id  = (int)$p->getVar('poll_id');
        // Affichage HTML : 's' (safe) → accents OK, pas de double-échappement
        $q   = $p->getVar('question','s');
        $st  = (string)$p->getVar('status');

        if ($st === 'draft')      { $stLabel = _AM_SP_DRAFT; }
        elseif ($st === 'closed') { $stLabel = _AM_SP_CLOSED; }
        else                      { $stLabel = _AM_SP_PUBLISHED; }

        // Compteurs
        $optCount  = $optHandler->getCount(new Criteria('poll_id', $id));
        $voteCount = $voteHandler->getCount(new Criteria('poll_id', $id));

        $rowClass = ($i++ % 2) ? 'odd' : 'even';
        $token    = $GLOBALS['xoopsSecurity']->createToken();

        $viewUrl    = XOOPS_URL . '/modules/sondages_pro/view.php?poll_id=' . $id;
        $resultsUrl = XOOPS_URL . '/modules/sondages_pro/results.php?poll_id=' . $id;

        echo '<tr class="' . $rowClass . '">';
        echo '  <td>' . $id . '</td>';
        echo '  <td>' . $q  . '</td>';
        echo '  <td>' . $stLabel . '</td>';
        echo '  <td style="text-align:right">' . (int)$optCount  . '</td>';
        echo '  <td style="text-align:right">' . (int)$voteCount . '</td>';
        echo '  <td>';
        echo '    <a href="poll.php?op=edit&poll_id=' . $id . '">' . _AM_SP_EDIT . '</a> | ';
        echo '    <a href="poll.php?op=delete&poll_id=' . $id . '&XOOPS_TOKEN_REQUEST=' . $token . '" onclick="return confirm(\'' . _AM_SP_CONFIRM_DELETE . '\');">' . _AM_SP_DELETE . '</a> | ';
        echo '    <a href="poll.php?op=status&poll_id=' . $id . '&val=published&XOOPS_TOKEN_REQUEST=' . $token . '">' . _AM_SP_PUBLISHED . '</a> | ';
        echo '    <a href="poll.php?op=status&poll_id=' . $id . '&val=draft&XOOPS_TOKEN_REQUEST=' . $token . '">' . _AM_SP_DRAFT . '</a> | ';
        echo '    <a href="poll.php?op=status&poll_id=' . $id . '&val=closed&XOOPS_TOKEN_REQUEST=' . $token . '">' . _AM_SP_CLOSED . '</a> | ';
        echo '    <a href="' . $viewUrl    . '" target="_blank">Voir</a> | ';
        echo '    <a href="' . $resultsUrl . '" target="_blank">Résultats</a> | ';
        echo '    <a href="votes.php?poll_id=' . $id . '">' . _AM_SP_VOTES . '</a> | ';
        echo '    <a href="export.php?poll_id=' . $id . '">Export CSV</a>';
        echo '  </td>';
        echo '</tr>';
    }
} else {
    echo '<tr class="even"><td colspan="6">(Aucun sondage)</td></tr>';
}
echo '</table>';

xoops_cp_footer();

