<?php
require __DIR__ . '/header.php';

xoops_loadLanguage('admin', 'sondages_pro');
include_once XOOPS_ROOT_PATH . '/class/pagenav.php';


$LBL_FILTERS            = defined('_AM_SP_FILTERS') ? _AM_SP_FILTERS : 'Filtres';
$LBL_OPTION_ALL         = defined('_AM_SP_OPTION_ALL') ? _AM_SP_OPTION_ALL : 'Toutes les options';
$LBL_SEARCH_PLACEHOLDER = defined('_AM_SP_SEARCH_PLACEHOLDER') ? _AM_SP_SEARCH_PLACEHOLDER : 'UID exact ou IP (partiel)';
$LBL_FILTER             = defined('_AM_SP_FILTER') ? _AM_SP_FILTER : 'Filtrer';
$LBL_RESET              = defined('_AM_SP_RESET') ? _AM_SP_RESET : 'Réinitialiser';

// Sécurité admin module
if (!is_object($GLOBALS['xoopsUser']) || !$GLOBALS['xoopsUser']->isAdmin($GLOBALS['xoopsModule']->getVar('mid'))) {
    redirect_header('poll.php', 3, _NOPERM);
    exit;
}

$pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
$optHandler  = xoops_getModuleHandler('option', 'sondages_pro');
$voteHandler = xoops_getModuleHandler('vote', 'sondages_pro');

// Récup params (GET/POST)
$pollId   = (int)($_REQUEST['poll_id'] ?? 0);
$optionId = (int)($_GET['option_id'] ?? 0);          // filtre option
$q        = trim((string)($_GET['q'] ?? ''));        // filtre uid/ip

// --- MODE SÉLECTEUR si aucun poll_id ---
if ($pollId <= 0) {
    // Liste des sondages pour choisir
    $crit = new CriteriaCompo();
    $crit->setSort('poll_id');
    $crit->setOrder('DESC');
    $polls = $pollHandler->getObjects($crit);

    echo '<h2>'._AM_SP_TITLE.' — '._AM_SP_VOTES.'</h2>';
    echo '<p>Sélectionnez un sondage pour voir ses votes :</p>';
    echo '<form method="get" action="votes.php">';
    echo '<select name="poll_id">';
    foreach ($polls as $p) {
        $id = (int)$p->getVar('poll_id');
        $qq = htmlspecialchars($p->getVar('question'), ENT_QUOTES);
        echo '<option value="'.$id.'">#'.$id.' — '.$qq.'</option>';
    }
    echo '</select> ';
    echo '<button type="submit" class="formButton">Voir</button>';
    echo '</form>';

    xoops_cp_footer();
    exit;
}

// --- MODE LISTE DES VOTES ---
$poll = $pollHandler->get($pollId);
if (!$poll) {
    redirect_header('votes.php', 2, _AM_SYSTEM_DBERROR);
    exit;
}

// Map option_id -> label
$optMap = [];
if (method_exists($optHandler, 'getByPoll')) {
    $opts = $optHandler->getByPoll($pollId);
} else {
    $oc = new Criteria('poll_id', $pollId);
    $opts = $optHandler->getObjects($oc);
}
foreach ($opts as $o) {
    $optMap[(int)$o->getVar('option_id')] = (string)$o->getVar('label');
}

// Compteurs globaux par option (pour badges)
$optCounts = [];
foreach ($optMap as $oid => $_) {
    $c = new CriteriaCompo(new Criteria('poll_id', $pollId));
    $c->add(new Criteria('option_id', (int)$oid));
    $optCounts[$oid] = $voteHandler->getCount($c);
}

// Pagination + filtres
$limit = max(10, (int)($_GET['limit'] ?? 30));
$start = max(0, (int)($_GET['start'] ?? 0));

// Critères COUNT (total filtré)
$criteriaCount = new CriteriaCompo(new Criteria('poll_id', $pollId));
if ($optionId > 0) {
    $criteriaCount->add(new Criteria('option_id', $optionId));
}
if ($q !== '') {
    // si numérique => match UID exact, sinon IP LIKE
    if (ctype_digit($q)) {
        $criteriaCount->add(new Criteria('uid', (int)$q));
    } else {
        $criteriaCount->add(new Criteria('ip', '%'.$q.'%', 'LIKE'));
    }
}
$total = $voteHandler->getCount($criteriaCount);

// Critères LISTE (copie + tri/pagination)
$criteria = clone $criteriaCount;
$criteria->setSort('created_at');
$criteria->setOrder('DESC');
$criteria->setStart($start);
$criteria->setLimit($limit);

$votes = $voteHandler->getObjects($criteria);

// Rendu
echo '<h2>'._AM_SP_TITLE.' — '._AM_SP_VOTES.'</h2>';
echo '<p><strong>'._AM_SP_POLL.':</strong> '.htmlspecialchars($poll->getVar('question'), ENT_QUOTES).'</p>';

// Formulaire de filtres
$baseUrl = 'votes.php?poll_id='.$pollId;
echo '<form method="get" action="votes.php" style="margin:10px 0">';
echo '<input type="hidden" name="poll_id" value="'.$pollId.'">';
echo '<label>'.$LBL_FILTERS.' : ';
echo '<select name="option_id">';
echo '<option value="0">'.$LBL_OPTION_ALL.'</option>';
foreach ($optMap as $oid => $label) {
    $sel   = ($optionId === (int)$oid) ? ' selected' : '';
    $badge = isset($optCounts[$oid]) ? ' ('.$optCounts[$oid].')' : '';
    echo '<option value="'.$oid.'"'.$sel.'>'.htmlspecialchars($label, ENT_QUOTES).$badge.'</option>';
}
echo '</select> ';
echo '<input type="text" name="q" value="'.htmlspecialchars($q, ENT_QUOTES).'" placeholder="'.$LBL_SEARCH_PLACEHOLDER.'" />';
echo ' <button class="formButton" type="submit">'.$LBL_FILTER.'</button> ';
echo ' <a class="formButton" href="'.$baseUrl.'">'.$LBL_RESET.'</a>';
echo '</label>';
echo '</form>';

if ($total > 0) {
    echo '<table class="outer" cellspacing="1" cellpadding="4" style="max-width:1000px">';
    echo '<tr class="head">';
    echo '  <th>'._AM_SP_VOTE_ID.'</th>';
    echo '  <th>'._AM_SP_OPTION.'</th>';
    echo '  <th>'._AM_SP_USER.'</th>';
    echo '  <th>IP</th>';
    echo '  <th>'._AM_SP_DATE.'</th>';
    echo '</tr>';

    $i = 0;
    foreach ($votes as $v) {
        $row = ($i++ % 2) ? 'odd' : 'even';
        $vid = (int)$v->getVar('vote_id');
        $oid = (int)$v->getVar('option_id');
        $uid = (int)$v->getVar('uid');
        $ip  = htmlspecialchars((string)$v->getVar('ip'), ENT_QUOTES);
        $dt  = htmlspecialchars((string)$v->getVar('created_at'), ENT_QUOTES);

        $label   = htmlspecialchars($optMap[$oid] ?? ('#'.$oid), ENT_QUOTES);
        $userHtml = $uid > 0
            ? '<a href="'.XOOPS_URL.'/userinfo.php?uid='.$uid.'" target="_blank">#'.$uid.'</a>'
            : _AM_SP_GUEST;

        echo '<tr class="'.$row.'">';
        echo '  <td>'.$vid.'</td>';
        echo '  <td>'.$label.'</td>';
        echo '  <td>'.$userHtml.'</td>';
        echo '  <td>'.$ip.'</td>';
        echo '  <td>'.$dt.'</td>';
        echo '</tr>';
    }
    echo '</table>';


    $qParams = 'poll_id='.$pollId.'&limit='.$limit.'&option_id='.$optionId.'&q='.rawurlencode($q);
    $nav = new XoopsPageNav($total, $limit, $start, 'start', $qParams);
    echo '<div style="margin-top:8px">'.$nav->renderNav().'</div>';
} else {
    echo '<div class="even" style="padding:.8rem;">'._AM_SP_NO_VOTES.'</div>';
}


$resultsUrl = XOOPS_URL . '/modules/sondages_pro/results.php?poll_id='.$pollId;
$exportUrl  = 'export.php?poll_id='.$pollId.($optionId>0 ? '&option_id='.$optionId : '');
echo '<p style="margin-top:10px">';
echo '  <a class="formButton" href="poll.php">'._AM_SP_BACK.'</a> ';
echo '  <a class="formButton" href="'.$resultsUrl.'" target="_blank">'._AM_SP_RESULTS.'</a> ';
// Export CSV filtré par option (q n’est pas supporté dans export.php, on ne le passe pas)
echo '  <a class="formButton" href="'.$exportUrl.'">'._AM_SP_EXPORT_CSV.'</a>';
echo '</p>';

xoops_cp_footer();

