<?php
declare(strict_types=1);

/**
 * Bloc "Derniers résultats" — Sondages Pro
 * Options:
 *   [0] = limite (défaut 5)
 *   [1] = min_votes (défaut 1)
 *   [2] = only_finished (0/1) — n’afficher que les sondages terminés
 */
function sp_block_results_show($options = [])
{
    global $xoopsDB;

    $limit        = isset($options[0]) ? max(1, (int)$options[0]) : 5;
    $minVotes     = isset($options[1]) ? max(1, (int)$options[1]) : 1;
    $onlyFinished = !empty($options[2]);

    $block = ['polls' => [], 'limit' => $limit];

    // 1) Récupère les sondages qui ont des votes, avec dernier vote + nb de votes
    $tblVote = $xoopsDB->prefix('sp_votes');
    $sql = "SELECT v.poll_id,
                   MAX(v.created_at) AS last_vote,
                   COUNT(*)          AS votes
            FROM {$tblVote} v
            GROUP BY v.poll_id
            HAVING COUNT(*) >= {$minVotes}
            ORDER BY last_vote DESC";
    $res = $xoopsDB->query($sql, $limit, 0);
    if (!$res) {
        return $block;
    }

    $ids  = [];
    $meta = []; // poll_id => ['last_vote'=>..., 'votes'=>...]
    while ($row = $xoopsDB->fetchArray($res)) {
        $pid = (int)$row['poll_id'];
        $ids[] = $pid;
        $meta[$pid] = [
            'last_vote' => $row['last_vote'],
            'votes'     => (int)$row['votes'],
        ];
    }
    if (empty($ids)) {
        return $block;
    }

    // 2) Charge les infos de poll via le handler
    $pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
    $criteria = new Criteria('poll_id', '(' . implode(',', array_map('intval', $ids)) . ')', 'IN');
    /** @var XoopsObject[] $pollObjs */
    $pollObjs = $pollHandler->getObjects($criteria, true);

    $now = date('Y-m-d H:i:s');

    foreach ($ids as $pid) { // conserve l’ordre du SQL (dernier vote desc)
        if (empty($pollObjs[$pid])) continue;
        $p = $pollObjs[$pid];

        $status = strtolower((string)$p->getVar('status'));
        $ends   = (string)$p->getVar('ends_at');

        if ($onlyFinished) {
            $endedByDate = ($ends !== '' && $ends !== '0000-00-00 00:00:00' && $ends < $now);
            $endedByFlag = ($status === 'closed');
            if (!$endedByDate && !$endedByFlag) {
                continue;
            }
        }

        $block['polls'][] = [
            'poll_id'     => $pid,
            'question'    => (string)$p->getVar('question', 'n'),
            'url_results' => XOOPS_URL . '/modules/sondages_pro/results.php?poll_id=' . $pid,
            'votes'       => $meta[$pid]['votes'] ?? 0,
            'last_vote'   => $meta[$pid]['last_vote'] ?? null,
        ];
    }

    return $block;
}

/** Éditeur d’options du bloc (facultatif) */
function sp_block_results_edit($options)
{
    $limit        = isset($options[0]) ? (int)$options[0] : 5;
    $minVotes     = isset($options[1]) ? (int)$options[1] : 1;
    $onlyFinished = !empty($options[2]) ? 1 : 0;

    $h  = 'Nombre d’éléments : <input type="number" name="options[0]" value="'.$limit.'" min="1" style="width:60px"><br>';
    $h .= 'Votes minimum : <input type="number" name="options[1]" value="'.$minVotes.'" min="1" style="width:60px"><br>';
    $h .= 'Uniquement sondages terminés : <select name="options[2]">';
    $h .= '<option value="0"'.($onlyFinished ? '' : ' selected').'>Non</option>';
    $h .= '<option value="1"'.($onlyFinished ? ' selected' : '').'>Oui</option>';
    $h .= '</select>';
    return $h;
}

