<?php
defined('XOOPS_ROOT_PATH') || exit('Restricted access');

class Option extends XoopsObject {
    public function __construct() {
        parent::__construct();
        $this->initVar('option_id', XOBJ_DTYPE_INT, null, false);
        $this->initVar('poll_id', XOBJ_DTYPE_INT, 0, true);
        $this->initVar('label', XOBJ_DTYPE_TXTBOX, '', true, 255);
        $this->initVar('sort_order', XOBJ_DTYPE_INT, 0);
    }
}

class OptionHandler extends XoopsPersistableObjectHandler {
    public function __construct($db) {
        parent::__construct($db, 'sp_options', 'Option', 'option_id', 'label');
    }

    public function getByPoll($pollId) {
        $criteria = new Criteria('poll_id', (int)$pollId);
        $criteria->setSort('sort_order');
        return $this->getObjects($criteria);
    }
}

if (!class_exists('Sondages_proOptionHandler')) {
    class Sondages_proOptionHandler extends OptionHandler {}
}
if (!class_exists('SondagesProOptionHandler')) {
    class SondagesProOptionHandler extends OptionHandler {}
}

