<?php
defined('XOOPS_ROOT_PATH') || exit('Restricted access');

class Poll extends XoopsObject {
    public function __construct() {
        parent::__construct();
        $this->initVar('poll_id', XOBJ_DTYPE_INT, null, false);
        $this->initVar('question', XOBJ_DTYPE_TXTBOX, '', true, 255);
        $this->initVar('description', XOBJ_DTYPE_TXTAREA, '');
        $this->initVar('is_multiple', XOBJ_DTYPE_INT, 0);
        $this->initVar('max_choices', XOBJ_DTYPE_INT, 1);
        $this->initVar('starts_at', XOBJ_DTYPE_TXTBOX, '');
        $this->initVar('ends_at', XOBJ_DTYPE_TXTBOX, '');
        $this->initVar('status', XOBJ_DTYPE_TXTBOX, 'published');
        $this->initVar('created_by', XOBJ_DTYPE_INT, 0);
        $this->initVar('created_at', XOBJ_DTYPE_TXTBOX, '');
        $this->initVar('updated_at', XOBJ_DTYPE_TXTBOX, '');
    }
}

class PollHandler extends XoopsPersistableObjectHandler {
    public function __construct($db) {
        parent::__construct($db, 'sp_polls', 'Poll', 'poll_id', 'question');
    }

    public function getActivePolls() {
        $criteria = new CriteriaCompo();
        $now = date('Y-m-d H:i:s');
        $criteria->add(new Criteria('status', 'published'));
        $criteria->add(new Criteria('starts_at', $now, '<='));
        $criteria->add(new Criteria('ends_at', $now, '>='));
        return $this->getObjects($criteria);
    }
}


if (!class_exists('Sondages_proPollHandler')) {
    class Sondages_proPollHandler extends PollHandler {}
}
if (!class_exists('SondagesProPollHandler')) {
    class SondagesProPollHandler extends PollHandler {}
}

