<?php
defined('XOOPS_ROOT_PATH') || exit('Restricted access');

class Vote extends XoopsObject {
    public function __construct() {
        parent::__construct();
        $this->initVar('vote_id', XOBJ_DTYPE_INT, null, false);
        $this->initVar('poll_id', XOBJ_DTYPE_INT, 0, true);
        $this->initVar('option_id', XOBJ_DTYPE_INT, 0, true);
        $this->initVar('uid', XOBJ_DTYPE_INT, 0);
        $this->initVar('ip', XOBJ_DTYPE_TXTBOX, '');
        $this->initVar('created_at', XOBJ_DTYPE_TXTBOX, '');
    }
}

class VoteHandler extends XoopsPersistableObjectHandler {
    public function __construct($db) {
        parent::__construct($db, 'sp_votes', 'Vote', 'vote_id', 'poll_id');
    }

    public function hasVotedRecently($pollId, $uid, $minutes) {
        if ($minutes <= 0) return false;
        $criteria = new CriteriaCompo(new Criteria('poll_id', (int)$pollId));
        $criteria->add(new Criteria('uid', (int)$uid));
        $criteria->add(new Criteria('created_at', date('Y-m-d H:i:s', time() - $minutes*60), '>='));
        return $this->getCount($criteria) > 0;
    }
}

if (!class_exists('Sondages_proVoteHandler')) {
    class Sondages_proVoteHandler extends VoteHandler {}
}
if (!class_exists('SondagesProVoteHandler')) {
    class SondagesProVoteHandler extends VoteHandler {}
}

