<?php
// Bootstrap frontal du module sondages_pro (compatible XOOPS 2.5.x)

// 1) Initialiser XOOPS si besoin
if (!defined('XOOPS_ROOT_PATH')) {
    require dirname(__DIR__, 2) . '/mainfile.php'; // remonte de /modules/sondages_pro/ vers la racine
}

// 2) Nom du module
$moduleDirName = basename(__DIR__); // 'sondages_pro'

// 3) Utilitaires du module (charge sp_userCan, sp_isPollOpen, etc.)
require_once __DIR__ . '/include/common.php';

// 4) Charger la config du module de manière robuste (sans xoops_getModuleHelper)
$moduleConfig = [];
if (class_exists('\Xmf\Module\Helper')) {
    // Si XMF est présent
    $helper = \Xmf\Module\Helper::getHelper($moduleDirName);
    if ($helper) {
        $moduleConfig = (array)$helper->getConfig();
    }
} else {
    // Fallback noyau XOOPS 2.5.x
    $moduleHandler = xoops_getHandler('module');
    $module        = $moduleHandler->getByDirname($moduleDirName);
    if ($module) {
        $configHandler = xoops_getHandler('config');
        $moduleConfig  = (array)$configHandler->getConfigsByCat(0, (int)$module->getVar('mid'));
    }
}

// 5) Exposer la config (certaines pages lisent $xoopsModuleConfig)
$GLOBALS['xoopsModuleConfig'] = isset($GLOBALS['xoopsModuleConfig']) && is_array($GLOBALS['xoopsModuleConfig'])
    ? array_merge($GLOBALS['xoopsModuleConfig'], $moduleConfig)
    : $moduleConfig;

// NOTE : NE PAS inclure XOOPS_ROOT_PATH.'/header.php' ici : les pages front le feront elles-mêmes

