<?php
function sp_isPollOpen($poll): bool {
    $now = time();
    $start = $poll->getVar('starts_at') ? strtotime($poll->getVar('starts_at')) : 0;
    $end   = $poll->getVar('ends_at') ? strtotime($poll->getVar('ends_at')) : PHP_INT_MAX;
    return $poll->getVar('status') === 'published' && $now >= $start && $now <= $end;
}

function sp_moduleMid(): int {
    static $mid = 0;
    if ($mid) return $mid;
    if (isset($GLOBALS['xoopsModule']) && $GLOBALS['xoopsModule']->getVar('dirname') === 'sondages_pro') {
        $mid = (int)$GLOBALS['xoopsModule']->getVar('mid');
        return $mid;
    }
    $moduleHandler = xoops_getHandler('module');
    $module = $moduleHandler->getByDirname('sondages_pro');
    $mid = $module ? (int)$module->getVar('mid') : 0;
    return $mid;
}

function sp_userCan(string $permName, int $itemId = 0): bool {
    $mid = sp_moduleMid();
    if ($mid <= 0) return false;
    $memberHandler = xoops_getHandler('member');
    $groups = is_object($GLOBALS['xoopsUser']) ? $GLOBALS['xoopsUser']->getGroups() : [XOOPS_GROUP_ANONYMOUS];
    $gpermHandler = xoops_getHandler('groupperm');
    return $gpermHandler->checkRight($permName, $itemId, $groups, $mid);
}

