<?php
defined('XOOPS_ROOT_PATH') || exit('Restricted access');

function xoops_module_install_sondages_pro(XoopsModule $module): bool {
    $mid = (int)$module->getVar('mid');
    $gperm = xoops_getHandler('groupperm');


    $groups = [
        XOOPS_GROUP_ANONYMOUS, // visiteurs
        XOOPS_GROUP_USERS,     // membres
    ];


    foreach (['sp_view', 'sp_vote'] as $permName) {
        foreach ($groups as $gid) {
            if (!$gperm->checkRight($permName, 0, $gid, $mid)) {
                $gperm->addRight($permName, 0, $gid, $mid);
            }
        }
    }


    if (!$gperm->checkRight('sp_create', 0, XOOPS_GROUP_ADMIN, $mid)) {
        $gperm->addRight('sp_create', 0, XOOPS_GROUP_ADMIN, $mid);
    }
    return true;
}

