<?php
require __DIR__ . '/header.php';

if (!sp_userCan('sp_view')) {
    redirect_header(XOOPS_URL, 3, _NOPERM);
    exit;
}

$pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
$voteHandler = xoops_getModuleHandler('vote', 'sondages_pro');

// 1) Récupère les sondages publiés (tri du plus récent au plus ancien)
$criteria = new CriteriaCompo(new Criteria('status', 'published'));
$criteria->setSort('created_at');
$criteria->setOrder('DESC');
$polls = $pollHandler->getObjects($criteria);

// 2) Ajoute votes_count à chaque sondage (OK en PHP 7.4)
foreach ($polls as $p) {
    $pid = (int)$p->getVar('poll_id');
    $p->votes_count = $voteHandler->getCount(new Criteria('poll_id', $pid));
}

// 3) Affiche le template
$xoopsOption['template_main'] = 'sondages_pro_index.tpl';
include XOOPS_ROOT_PATH . '/header.php';
$xoopsTpl->assign('polls', $polls);
include XOOPS_ROOT_PATH . '/footer.php';

