<?php
require __DIR__ . '/header.php';
require_once __DIR__ . '/include/functions.php';

$pollId = (int)($_GET['poll_id'] ?? 0);

$pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
$optHandler  = xoops_getModuleHandler('option', 'sondages_pro');
$voteHandler = xoops_getModuleHandler('vote', 'sondages_pro');

$pollObj = $pollHandler->get($pollId);
if (!$pollObj) {
    redirect_header('index.php', 2, _AM_SYSTEM_DBERROR);
    exit;
}

// Permissions de lecture
if (!sp_userCan('sp_view')) {
    redirect_header(XOOPS_URL, 3, _NOPERM);
    exit;
}

// Prépare poll pour Smarty
$poll = [
    'poll_id'     => (int)$pollObj->getVar('poll_id'),
    'question'    => (string)$pollObj->getVar('question','n'),
    'description' => (string)$pollObj->getVar('description','n'),
    'is_multiple' => (int)$pollObj->getVar('is_multiple'),
    'max_choices' => (int)$pollObj->getVar('max_choices'),
    'starts_at'   => (string)$pollObj->getVar('starts_at'),
    'ends_at'     => (string)$pollObj->getVar('ends_at'),
    'status'      => (string)$pollObj->getVar('status'),
];

// Options triées
$optionsObj = $optHandler->getByPoll($pollId);
$counts = [];
$labels = [];
$rows   = [];
foreach ($optionsObj as $o) {
    $oid = (int)$o->getVar('option_id');
    $counts[$oid] = 0;
    $labels[$oid] = (string)$o->getVar('label');
}

// Votes → comptages
$criteria = new Criteria('poll_id', $pollId);
$votes = $voteHandler->getObjects($criteria);
foreach ($votes as $v) {
    $oid = (int)$v->getVar('option_id');
    if (isset($counts[$oid])) {
        $counts[$oid]++;
    }
}

$total = 0;
foreach ($counts as $c) $total += $c;

// Construit lignes + datasets
$chartLabels = [];
$chartData   = [];
foreach ($optionsObj as $o) {
    $oid   = (int)$o->getVar('option_id');
    $label = $labels[$oid];
    $count = $counts[$oid] ?? 0;
    $pct   = $total > 0 ? round(($count / $total) * 100, 1) : 0.0;

    $rows[] = [
        'label' => $label,
        'count' => $count,
        'percent' => $pct,
    ];
    $chartLabels[] = $label;
    $chartData[]   = $count;
}


$canVote = sp_userCan('sp_vote') && sp_isPollOpen($pollObj);

$xoopsOption['template_main'] = 'sondages_pro_results.tpl';
include XOOPS_ROOT_PATH . '/header.php';

$xoopsTpl->assign('poll', $poll);
$xoopsTpl->assign('rows', $rows);
$xoopsTpl->assign('total', (int)$total);
$xoopsTpl->assign('chartLabelsJson', json_encode($chartLabels, JSON_UNESCAPED_UNICODE));
$xoopsTpl->assign('chartDataJson',   json_encode($chartData));
$xoopsTpl->assign('can_vote', $canVote ? 1 : 0);
$xoopsTpl->assign('view_url', XOOPS_URL . '/modules/sondages_pro/view.php?poll_id='.$pollId);

include XOOPS_ROOT_PATH . '/footer.php';

