<style>
/* ===== Bloc Sondages Pro — Liste (scopé) ===== */
#spb-polls { --b:#e5e7eb; --bg:#fff; --t:#0f172a; --sub:#64748b; }
#spb-polls { color:var(--t); }
#spb-polls .spb-list{list-style:none;margin:0;padding:0;display:grid;grid-template-columns:1fr;gap:8px}
#spb-polls .spb-item a{
  display:flex;align-items:center;gap:8px;
  border:1px solid var(--b);background:var(--bg);border-radius:10px;
  padding:10px 12px;text-decoration:none;color:inherit;
  transition:transform .12s, box-shadow .12s, border-color .12s;
}
#spb-polls .spb-item a:hover{transform:translateY(-2px);box-shadow:0 6px 18px rgba(0,0,0,.06);border-color:#cbd5e1}
#spb-polls .spb-title{flex:1;font-weight:600;line-height:1.3;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden}
#spb-polls .spb-meta{font-size:.85rem;color:var(--sub);white-space:nowrap}
#spb-polls .spb-arrow{font-size:1rem;opacity:.6}
#spb-polls .spb-empty{border:1px dashed var(--b);border-radius:10px;background:#f8fafc;padding:.7rem;text-align:center;color:var(--sub)}
</style>

<div id="spb-polls">
  <{if $block.polls|@count > 0}>
    <ul class="spb-list">
      <{foreach item=p from=$block.polls}>
        <li class="spb-item">
          <a href="<{$p.url_view}>">
            <span class="spb-title"><{$p.question|escape}></span>
            <{* Affiche le nombre de votes si disponible *}>
            <{if isset($p.votes_count) && $p.votes_count|default:0 > 0}>
              <span class="spb-meta">🗳️ <{$p.votes_count|default:0}> 1</span>
            <{/if}>
            <span class="spb-arrow">→</span>
          </a>
        </li>
      <{/foreach}>
    </ul>
  <{else}>
    <div class="spb-empty">Aucun sondage en cours.</div>
  <{/if}>
</div>

