<style>
  .sp-polls-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(260px,1fr));gap:12px;margin:12px 0}
  .sp-card{border:1px solid #e5e7eb;border-radius:12px;padding:14px;background:#fff;transition:transform .12s,box-shadow .12s,border-color .12s;text-decoration:none;color:inherit;display:block}
  .sp-card:hover{transform:translateY(-2px);box-shadow:0 6px 22px rgba(0,0,0,.06);border-color:#cbd5e1}
  .sp-title{font-size:1.05rem;font-weight:600;margin:0 0 6px}
  .sp-meta{font-size:.86rem;color:#6b7280;display:flex;gap:10px;flex-wrap:wrap}
  .sp-badge{font-size:.72rem;padding:2px 8px;border-radius:999px;background:#eef2ff;color:#3730a3;border:1px solid #c7d2fe}
  .sp-badge.draft{background:#fff7ed;color:#9a3412;border-color:#fed7aa}
  .sp-badge.closed{background:#f1f5f9;color:#334155;border-color:#cbd5e1}
  .sp-dates{margin-top:8px;font-size:.82rem;color:#64748b}
  .sp-empty{padding:12px;border:1px dashed #cbd5e1;border-radius:12px;background:#f8fafc}
</style>

<h2 style="margin-top:0">Sondages</h2>

<{if $polls|@count > 0}>
  <div class="sp-polls-grid">
    <{foreach from=$polls item=p}>
      <{assign var=__id value=$p->getVar('poll_id')}>
      <{assign var=__status value=$p->getVar('status')|default:'published'}>
      <{assign var=__statusClass value=''}><{if $__status=='draft'}><{assign var=__statusClass value='draft'}><{/if}><{if $__status=='closed'}><{assign var=__statusClass value='closed'}><{/if}>

      <a class="sp-card" href="view.php?poll_id=<{$__id}>">
        <div class="sp-title"><{$p->getVar('question')}></div>

        <div class="sp-meta">
          <span class="sp-badge <{$__statusClass}>">
            <{if $__status=='draft'}>Brouillon<{elseif $__status=='closed'}>Fermé<{else}>Publié<{/if}>
          </span>
          <{* Affiche le nombre de votes si tu le passes depuis PHP en $p->votes_count *}>
          <{if $p->votes_count|default:0 > 0}>
            <span>🗳️ <{$p->votes_count|default:0}> vote(s)</span>
          <{/if}>
        </div>

        <{assign var=__start value=$p->getVar('starts_at')|default:''}>
        <{assign var=__end   value=$p->getVar('ends_at')|default:''}>
        <{if $__start || $__end}>
          <div class="sp-dates">
            <{if $__start}>Début : <{$__start|escape}><{/if}>
            <{if $__start && $__end}> • <{/if}>
            <{if $__end}>Fin : <{$__end|escape}><{/if}>
          </div>
        <{/if}>
      </a>
    <{/foreach}>
  </div>
<{else}>
  <div class="sp-empty">Aucun sondage.</div>
<{/if}>

