<style>

#sp-results { --sp-b:#e5e7eb; --sp-bg:#fff; --sp-t:#0f172a; --sp-sub:#64748b; --sp-ac:#4f46e5; --sp-ac2:#22c55e; }
#sp-results.sp-wrap{max-width:980px;margin:0 auto;color:var(--sp-t)}
#sp-results .sp-header{display:flex;flex-wrap:wrap;gap:8px 14px;align-items:flex-end;margin:6px 0 14px}
#sp-results .sp-title{font-size:1.4rem;font-weight:700;line-height:1.2;margin:0}
#sp-results .sp-sub{color:var(--sp-sub);margin:0}
#sp-results .sp-kpis{display:flex;gap:12px;flex-wrap:wrap;margin-top:6px}
#sp-results .sp-kpi{background:var(--sp-bg);border:1px solid var(--sp-b);border-radius:10px;padding:6px 10px;font-size:.9rem}
#sp-results .sp-kpi b{font-weight:700}

#sp-results .sp-grid{display:grid;grid-template-columns:1.05fr .95fr;gap:16px}
@media (max-width: 900px){ #sp-results .sp-grid{grid-template-columns:1fr} }

#sp-results .sp-card{background:var(--sp-bg);border:1px solid var(--sp-b);border-radius:12px;padding:14px}
#sp-results .sp-card h3{margin:.1rem 0 .6rem;font-size:1rem}


#sp-results .sp-rows{display:flex;flex-direction:column;gap:10px}
#sp-results .sp-row{border:1px solid var(--sp-b);border-radius:10px;padding:10px}
#sp-results .sp-row-top{display:flex;justify-content:space-between;gap:10px;align-items:baseline}
#sp-results .sp-row-label{font-weight:600}
#sp-results .sp-row-meta{font-variant-numeric:tabular-nums;color:var(--sp-sub);white-space:nowrap}
#sp-results .sp-bar{position:relative;background:#f8fafc;border:1px solid var(--sp-b);border-radius:999px;height:10px;margin-top:8px;overflow:hidden}
#sp-results .sp-bar > span{display:block;height:100%;width:0;transition:width .6s ease}
/* Couleurs alternées */
#sp-results .sp-bar > span.is-a{background:linear-gradient(90deg,#a5b4fc,#6366f1)}
#sp-results .sp-bar > span.is-b{background:linear-gradient(90deg,#86efac,#22c55e)}


#sp-results .sp-chart-box{min-height:380px}
#sp-results .sp-chart-wrap{position:relative;height:360px}

/* Alertes & actions */
#sp-results .sp-alert{background:#fff3cd;border:1px solid #ffe08a;padding:.75rem;border-radius:8px}
#sp-results .sp-actions{margin-top:12px;display:flex;gap:8px;flex-wrap:wrap}
#sp-results .sp-btn{display:inline-block;padding:.45rem .8rem;border:1px solid var(--sp-b);border-radius:8px;background:#f7f7f7;text-decoration:none;cursor:pointer}
#sp-results .sp-btn:hover{background:#eee}
</style>

<div id="sp-results" class="sp-wrap">
  <div class="sp-header">
    <h2 class="sp-title">Résultats — <{$poll.question|escape}></h2>
    <div class="sp-kpis">
      <div class="sp-kpi">🗳️ <b><{$total}></b> vote(s)</div>
      <{if $rows|@count > 0}>
        <div class="sp-kpi">🔢 <b><{$rows|@count}></b> option(s)</div>
      <{/if}>
    </div>
    <{if $poll.description|strip}>
      <p class="sp-sub"><{$poll.description|escape}></p>
    <{/if}>
  </div>

  <{if $total > 0}>
    <div class="sp-grid">
      <!-- Carte : répartition détaillée -->
      <div class="sp-card">
        <h3>Détail par option</h3>
        <div class="sp-rows">
          <{foreach item=r from=$rows name=rs}>
            <{assign var=__pct value=$r.percent|default:0}>
            <div class="sp-row" aria-label="Option: <{$r.label|escape}> — <{$r.count}> votes — <{$__pct}>%">
              <div class="sp-row-top">
                <div class="sp-row-label"><{$r.label|escape}></div>
                <div class="sp-row-meta">
                  <span><{$r.count}> vote(s)</span> • <span><{$__pct}>%</span>
                </div>
              </div>
              <div class="sp-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="<{$__pct}>">
                <span class="<{if $smarty.foreach.rs.iteration%2==1}>is-a<{else}>is-b<{/if}>" style="width:<{$__pct}>%"></span>
              </div>
            </div>
          <{/foreach}>
        </div>
      </div>

      <!-- Carte : graphique avec sélecteur -->
      <div class="sp-card sp-chart-box">
        <div style="display:flex;align-items:center;justify-content:space-between;gap:8px;">
          <h3>Graphique</h3>
          <div style="display:flex;align-items:center;gap:8px;">
            <label style="font-size:.9rem;color:#64748b">
              Affichage :
              <select id="spChartType">
                <option value="bar">Histogramme</option>
                <option value="pie">Camembert</option>
                <option value="doughnut">Donut</option>
              </select>
            </label>
            <button id="spChartDl" type="button" class="sp-btn">Exporter PNG</button>
          </div>
        </div>
        <div class="sp-chart-wrap">
          <canvas id="spChart"></canvas>
        </div>
      </div>
    </div>

  <{else}>
    <div class="sp-alert">Aucun vote pour le moment.</div>
  <{/if}>

  <div class="sp-actions">
    <a class="sp-btn" href="<{$view_url}>">Retour à la page du sondage</a>
    <{if $can_vote == 1}>
      <a class="sp-btn" href="<{$view_url}>#vote">Voter</a>
    <{/if}>
  </div>
</div>

<{if $total > 0}>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
(function(){
  // Données JSON envoyées par PHP (doivent être valides)
  var labels = <{$chartLabelsJson}>;
  var data   = <{$chartDataJson}>;

  function getUrlChartType(){ var m = location.search.match(/[?&]chart=(bar|pie|doughnut)\b/); return m ? m[1] : null; }
  function getSavedChartType(){ try{ return localStorage.getItem('spChartType')||null; }catch(_){ return null; } }
  function saveChartType(t){ try{ localStorage.setItem('spChartType', t); }catch(_){} }
  function genColors(n, alpha){
    var out = [];
    for (var i=0;i<n;i++){
      var hue = (i * 137.508) % 360; // angle d’or
      out.push('hsla('+hue+',65%,55%,'+(alpha==null?1:alpha)+')');
    }
    return out;
  }

  var root = document.getElementById('sp-results');
  if (!root) return;
  var el  = root.querySelector('#spChart');
  var sel = root.querySelector('#spChartType');
  var dl  = root.querySelector('#spChartDl');
  if (!el || !sel) return;

  var initial = getUrlChartType() || getSavedChartType() || 'bar';
  if (!/^(bar|pie|doughnut)$/.test(initial)) initial = 'bar';
  sel.value = initial;

  var chart;
  function makeConfig(type){
    var colorsFill = genColors(labels.length, type==='bar' ? 0.35 : 0.85);
    var colorsLine = genColors(labels.length, 0.95);

    if (type === 'bar') {
      return {
        type: 'bar',
        data: { labels: labels, datasets: [{ label: 'Votes', data: data, backgroundColor: colorsFill, borderColor: colorsLine, borderWidth: 1 }] },
        options: {
          responsive: true, maintainAspectRatio: false,
          plugins: { legend: { display: false }, tooltip: { mode: 'index', intersect: false } },
          scales: { x: { ticks: { autoSkip: false } }, y: { beginAtZero: true, precision: 0, title: { display: true, text: 'Votes' } } }
        }
      };
    } else {
      return {
        type: type, // 'pie' ou 'doughnut'
        data: { labels: labels, datasets: [{ data: data, backgroundColor: colorsFill, borderColor: 'rgba(255,255,255,0.9)', borderWidth: 1 }] },
        options: {
          responsive: true, maintainAspectRatio: false,
          plugins: { legend: { position: 'bottom' }, tooltip: { callbacks: {
            label: function(ctx){ var v = ctx.raw, total = data.reduce((a,b)=>a+b,0)||1; var pct = Math.round((v*100)/total); return ctx.label+': '+v+' ('+pct+'%)'; }
          } } }
        }
      };
    }
  }

  function buildChart(type){ if (chart) chart.destroy(); chart = new Chart(el.getContext('2d'), makeConfig(type)); }

  buildChart(initial);

  sel.addEventListener('change', function(){ var t = sel.value; saveChartType(t); buildChart(t); });

  if (dl) {
    dl.addEventListener('click', function(){
      try {
        var url = el.toDataURL('image/png');
        var a = document.createElement('a');
        a.href = url; a.download = 'resultats_sondage.png';
        document.body.appendChild(a); a.click(); document.body.removeChild(a);
      } catch(e) {}
    });
  }
})();
</script>
<{/if}>

