<{* Sondage : page de vote (scopé) *}>

<style>
/* ===== Sondages Pro — Vote (scopé) ===== */
#sp-vote { --sp-b:#e5e7eb; --sp-bg:#fff; --sp-t:#0f172a; --sp-sub:#64748b; --sp-ok:#16a34a; --sp-warn:#9a3412; --sp-info:#2563eb; --sp-muted:#f8fafc; }
#sp-vote { max-width:880px; margin:0 auto; color:var(--sp-t); }
#sp-vote .sp-head{margin:6px 0 14px}
#sp-vote .sp-title{font-size:1.4rem;font-weight:700;margin:0 0 6px}
#sp-vote .sp-desc{color:var(--sp-sub);margin:.25rem 0 0}
#sp-vote .sp-meta{display:flex;gap:10px;flex-wrap:wrap;margin:10px 0 16px;padding:0}
#sp-vote .sp-badge{display:inline-flex;align-items:center;gap:6px;padding:4px 10px;border:1px solid var(--sp-b);border-radius:999px;background:var(--sp-bg);font-size:.85rem}
#sp-vote .sp-badge.ok{border-color:#bbf7d0;background:#f0fdf4;color:#14532d}
#sp-vote .sp-badge.warn{border-color:#fed7aa;background:#fff7ed;color:#7c2d12}
#sp-vote .sp-badge.info{border-color:#bfdbfe;background:#eff6ff;color:#1e3a8a}

#sp-vote .sp-card{background:var(--sp-bg);border:1px solid var(--sp-b);border-radius:12px;padding:14px}
#sp-vote .sp-opts{display:grid;grid-template-columns:1fr;gap:10px}
#sp-vote .sp-opt label{display:flex;gap:10px;align-items:flex-start;border:1px solid var(--sp-b);border-radius:12px;padding:10px;background:var(--sp-muted);cursor:pointer;transition:border-color .12s, background .12s}
#sp-vote .sp-opt input{margin-top:2px}
#sp-vote .sp-opt .sp-lab{display:block;line-height:1.35}
#sp-vote .sp-opt label:hover{background:#f1f5f9}
#sp-vote .sp-opt input:checked + .sp-lab{font-weight:600}
#sp-vote .sp-opt.is-locked label{opacity:.65}
#sp-vote .sp-help{margin:.25rem 0 .5rem;color:var(--sp-sub);font-size:.9rem}

#sp-vote .sp-actions{display:flex;gap:8px;flex-wrap:wrap;margin-top:12px}
#sp-vote .sp-btn{display:inline-block;padding:.5rem .9rem;border:1px solid var(--sp-b);border-radius:10px;background:#1370F2;text-decoration:none;cursor:pointer}
#sp-vote .sp-btn:hover{background:#505D61}
#sp-vote .sp-btn[disabled]{opacity:.6;cursor:not-allowed}

#sp-vote .sp-alert{background:#fff3cd;border:1px solid #ffe08a;padding:.8rem;border-radius:10px}
</style>

<div id="sp-vote">
<{if $flash_error|strip}>
  <div class="sp-alert sp-card" style="margin-bottom:.8rem"><{$flash_error|escape}></div>
<{/if}>
<{if $flash_ok|strip}>
  <div class="sp-card" style="border:1px solid #bbf7d0;background:#f0fdf4;color:#14532d;margin-bottom:.8rem">
    <p style="margin:.3rem 0"><{$flash_ok|escape}></p>
  </div>
<{/if}>

  <div class="sp-head">
    <h2 class="sp-title"><{$poll.question|escape}></h2>
    <{if $poll.description|strip}><p class="sp-desc"><{$poll.description|escape}></p><{/if}>

    <ul class="sp-meta">
      <li class="sp-badge <{if $poll.status=='published'}>ok<{elseif $poll.status=='draft'}>warn<{else}>info<{/if}>">
        <strong>Statut :</strong> <span><{$poll.status|escape}></span>
      </li>
      <{if $poll.starts_at|strip}>
        <li class="sp-badge info"><strong>Début :</strong> <span><{$poll.starts_at|escape}></span></li>
      <{/if}>
      <{if $poll.ends_at|strip}>
        <li class="sp-badge info"><strong>Fin :</strong> <span><{$poll.ends_at|escape}></span></li>
      <{/if}>
    </ul>
  </div>

 <{if $can_vote == 1}>
  <{if $has_voted == 1}>
    <div class="sp-alert sp-card">
      <strong>Vous avez déjà voté.</strong>
      <p style="margin:.4rem 0 0">Vous pouvez consulter les résultats actuels ci-dessous.</p>
      <div class="sp-actions" style="margin-top:.8rem">
        <a class="sp-btn" href="results.php?poll_id=<{$poll.poll_id}>">Voir les résultats</a>
      </div>
    </div>
  <{else}>
    <form id="sp-vote-form" class="sp-card" method="post" action="<{$form_action}>">
      <input type="hidden" name="poll_id" value="<{$poll.poll_id}>">

      <div class="sp-opts">
        <{if $is_multiple == 1}>
          <p class="sp-help">Vous pouvez sélectionner jusqu’à <strong><{$max_choices}></strong> option(s).</p>
          <{foreach item=o from=$options}>
            <div class="sp-opt">
              <label>
                <input type="checkbox" class="sp-choice" name="choices[]" value="<{$o.option_id}>">
                <span class="sp-lab"><{$o.label|escape}></span>
              </label>
            </div>
          <{/foreach}>
        <{else}>
          <p class="sp-help">Sélectionnez une seule option.</p>
          <{foreach item=o from=$options}>
            <div class="sp-opt">
              <label>
                <input type="radio" class="sp-choice" name="choice" value="<{$o.option_id}>" required>
                <span class="sp-lab"><{$o.label|escape}></span>
              </label>
            </div>
          <{/foreach}>
        <{/if}>
      </div>

      <div class="sp-actions">
        <button id="sp-submit" type="submit" class="sp-btn">Voter</button>
        <a class="sp-btn" href="results.php?poll_id=<{$poll.poll_id}>">Voir les résultats</a>
      </div>
    </form>

    <script>
    (function(){
      var root = document.getElementById('sp-vote');
      if (!root) return;
      var form   = document.getElementById('sp-vote-form');
      var submit = document.getElementById('sp-submit');
      var boxes  = [].slice.call(root.querySelectorAll('.sp-choice'));
      var isMultiple = '<{$is_multiple}>' === '1';
      var maxChoices = parseInt('<{$max_choices}>', 10) || 1;

      function refreshMultiple(){
        if (!isMultiple) return;
        var checked = boxes.filter(function(b){ return b.checked; }).length;
        var lock = checked >= maxChoices;
        boxes.forEach(function(b){
          if (!b.checked) b.disabled = lock;
          if (b.closest) b.closest('.sp-opt')?.classList.toggle('is-locked', lock && !b.checked);
        });
        if (submit) submit.disabled = checked === 0;
      }
      function refreshSingle(){
        if (isMultiple) return;
        var any = boxes.some(function(b){ return b.checked; });
        if (submit) submit.disabled = !any;
      }
      document.addEventListener('change', function(e){
        if (!e.target || !e.target.classList || !e.target.classList.contains('sp-choice')) return;
        refreshMultiple(); refreshSingle();
      });
      form && form.addEventListener('submit', function(){
        if (submit){ submit.disabled = true; submit.textContent = 'Envoi…'; }
      });
      refreshMultiple(); refreshSingle();
    })();
    </script>
  <{/if}>
<{else}>
  <div class="sp-alert sp-card">
    <strong>Le vote n’est pas disponible</strong>
    <ul style="margin:.5rem 0 0 .9rem">
      <li>Soit vous n’avez pas l’autorisation de voter.</li>
      <li>Soit le sondage n’est pas ouvert (statut, date de début/fin).</li>
    </ul>
    <div class="sp-actions" style="margin-top:.8rem">
      <a class="sp-btn" href="results.php?poll_id=<{$poll.poll_id}>">Voir les résultats</a>
    </div>
  </div>
<{/if}>
</div>
