<?php
if (!defined('SP_TRACE_ON'))  define('SP_TRACE_ON', false);
if (!defined('SP_TRACE_FILE')) define('SP_TRACE_FILE', __DIR__ . '/logs/sondages_pro.trace.log');

if (!function_exists('sp_mask')) {

    function sp_mask(?string $s, int $keep = 4): string
    {
        if ($s === null) return '';
        $len = strlen($s);
        if ($len <= $keep * 2) return $s;
        return substr($s, 0, $keep) . '…' . substr($s, -$keep);
    }
}

if (!function_exists('sp_trace')) {
   
    function sp_trace(string $tag, array $data = []): void
    {
        if (!SP_TRACE_ON) return;

        $file = SP_TRACE_FILE;
        $dir  = dirname($file);
        if (!is_dir($dir)) {
            @mkdir($dir, 0775, true);
        }

        $payload = $data ? ' ' . json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) : '';
        $line = '[' . date('Y-m-d H:i:s') . '] ' . $tag . $payload . PHP_EOL;

        @file_put_contents($file, $line, FILE_APPEND | LOCK_EX);
    }
}

