<?php
declare(strict_types=1);

require __DIR__ . '/header.php';
require_once __DIR__ . '/include/functions.php';


if (!defined('SP_TRACE_ON'))   define('SP_TRACE_ON', true);
if (!defined('SP_TRACE_FILE')) define('SP_TRACE_FILE', __DIR__ . '/logs/sondages_pro.trace.log');
if (is_file(__DIR__ . '/trace.php')) require_once __DIR__ . '/trace.php';
if (!function_exists('sp_trace')) { function sp_trace(string $e, array $d=[]): void {} }

sp_trace('VIEW_ENTER', [
    'uri' => ($_SERVER['REQUEST_URI'] ?? ''),
    'sid' => ($_COOKIE[session_name()] ?? '')
]);


header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

/* ===== Données de base ===== */
$pollId = (int)($_GET['poll_id'] ?? 0);

$pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
$optHandler  = xoops_getModuleHandler('option', 'sondages_pro');

if ($pollId <= 0 || !$pollHandler) {
    redirect_header('index.php', 2, 'Sondage introuvable.');
    exit;
}

$pollObj = $pollHandler->get($pollId);
if (!$pollObj) {
    redirect_header('index.php', 2, 'Sondage introuvable.');
    exit;
}

if (!sp_userCan('sp_view')) {
    redirect_header(XOOPS_URL, 3, 'Accès refusé.');
    exit;
}

/* Options du sondage */
$optionsObj = method_exists($optHandler, 'getByPoll')
    ? $optHandler->getByPoll($pollId)
    : $optHandler->getObjects(new Criteria('poll_id', $pollId));

$poll = [
    'poll_id'     => (int)$pollObj->getVar('poll_id'),
    'question'    => (string)$pollObj->getVar('question', 'n'),
    'description' => (string)$pollObj->getVar('description', 'n'),
    'is_multiple' => (int)$pollObj->getVar('is_multiple'),
    'max_choices' => (int)$pollObj->getVar('max_choices'),
    'starts_at'   => (string)$pollObj->getVar('starts_at'),
    'ends_at'     => (string)$pollObj->getVar('ends_at'),
    'status'      => (string)$pollObj->getVar('status'),
];

$options = [];
foreach ($optionsObj as $o) {
    $options[] = [
        'option_id' => (int)$o->getVar('option_id'),
        'label'     => (string)$o->getVar('label', 'n'),
    ];
}

$canVote = sp_userCan('sp_vote') && sp_isPollOpen($pollObj);

/* Détermine si l'utilisateur a déjà voté */
$voteHandler = xoops_getModuleHandler('vote', 'sondages_pro');
$uid = is_object($GLOBALS['xoopsUser']) ? (int)$GLOBALS['xoopsUser']->getVar('uid') : 0;
$hasVoted = false;

if ($uid > 0) {
    $c = new CriteriaCompo(new Criteria('poll_id', $pollId));
    $c->add(new Criteria('uid', $uid));
    $c->setLimit(1);
    $hasVoted = ($voteHandler->getCount($c) > 0);
} else {
    if (!empty($_COOKIE['spv_' . $pollId])) {
        $hasVoted = true;
    } else {
        $ip = (class_exists('XoopsUserUtility') && method_exists('XoopsUserUtility','getIP'))
            ? XoopsUserUtility::getIP(false)
            : ($_SERVER['REMOTE_ADDR'] ?? '');
        $ip = substr((string)$ip, 0, 45);

        $c = new CriteriaCompo(new Criteria('poll_id', $pollId));
        $c->add(new Criteria('uid', 0));
        if ($ip !== '') {
            $c->add(new Criteria('ip', $ip));
        }
        $c->setLimit(1);
        $hasVoted = ($voteHandler->getCount($c) > 0);
    }
}

sp_trace('VIEW_RENDER', [
    'poll_id'    => $pollId,
    'canVote'    => (int)$canVote,
    'token_area' => 'none',
    'opts'       => count($options),
]);

/* ===== Rendu ===== */
$xoopsOption['template_main'] = 'sondages_pro_view.tpl';
include XOOPS_ROOT_PATH . '/header.php';

$xoopsTpl->caching = 0;
$xoopsTpl->assign('poll', $poll);
$xoopsTpl->assign('options', $options);
$xoopsTpl->assign('is_multiple', (int)$poll['is_multiple']);
$xoopsTpl->assign('max_choices', max(1, (int)$poll['max_choices']));
$xoopsTpl->assign('can_vote', $canVote ? 1 : 0);
$xoopsTpl->assign('form_action', XOOPS_URL . '/modules/sondages_pro/vote.php');
$xoopsTpl->assign('has_voted', $hasVoted ? 1 : 0);  // 👈 déplacé APRÈS l'include header


$xoopsTpl->assign('token_html', '');
$xoopsTpl->assign('csrf_field', '');
$xoopsTpl->assign('csrf_token', '');

/* Flash */
$flash_error = '';
$flash_ok    = '';
if (!empty($_GET['err'])) {
    $map = [
        'perm'     => "Vous n’avez pas l’autorisation de voter.",
        'window'   => "Ce sondage n’est pas ouvert actuellement.",
        'choice'   => "Veuillez sélectionner une option valide.",
        'cooldown' => "Vous avez déjà voté récemment. Réessayez plus tard.",
        'token'    => "Votre session a expiré. Merci de réessayer.", // ne devrait plus arriver
    ];
    $flash_error = $map[$_GET['err']] ?? "Action impossible.";
}
if (!empty($_GET['ok'])) {
    $flash_ok = "Merci pour votre vote !";
}

$xoopsTpl->assign('flash_error', $flash_error);
$xoopsTpl->assign('flash_ok', $flash_ok);

include XOOPS_ROOT_PATH . '/footer.php';

