<?php
declare(strict_types=1);

require_once dirname(__DIR__, 2) . '/mainfile.php';
require_once __DIR__ . '/include/functions.php';


if (!defined('SP_TRACE_ON'))   define('SP_TRACE_ON', true);
if (!defined('SP_TRACE_FILE')) define('SP_TRACE_FILE', __DIR__ . '/logs/sondages_pro.trace.log');
if (is_file(__DIR__ . '/trace.php')) require_once __DIR__ . '/trace.php';
if (!function_exists('sp_trace')) { function sp_trace(string $e, array $d=[]): void {} }

/* Redirection sûre */
function sp_safe_redirect(string $url, int $code = 303): void {
    if (session_status() === PHP_SESSION_ACTIVE) @session_write_close();
    if (ob_get_length()) @ob_end_clean();
    if (!headers_sent()) { header('Location: '.$url, true, $code); exit; }
    $h = htmlspecialchars($url, ENT_QUOTES, 'UTF-8');
    echo '<!doctype html><meta charset="utf-8"><meta http-equiv="refresh" content="0;url='.$h.'">'; exit;
}


$method = $_SERVER['REQUEST_METHOD'] ?? '';
if ($method !== 'POST') {
    $pid = (int)($_POST['poll_id'] ?? $_GET['poll_id'] ?? 0);
    sp_trace('VOTE_BAD_METHOD', ['got'=>$method, 'pid'=>$pid]);
    sp_safe_redirect(XOOPS_URL . '/modules/sondages_pro/view.php?poll_id='.$pid.'&err=perm');
}


$pollId = (int)($_POST['poll_id'] ?? 0);
if ($pollId === 0 && !empty($_SERVER['HTTP_REFERER'])) {
    $q = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_QUERY);
    parse_str((string)$q, $refq);
    if (!empty($refq['poll_id'])) $pollId = (int)$refq['poll_id'];
}

$viewUrl = XOOPS_URL . '/modules/sondages_pro/view.php?poll_id=' . $pollId;
sp_trace('VOTE_ENTER', [
    'pid'       => $pollId,
    'sid'       => $_COOKIE[session_name()] ?? '',
    'post_keys' => implode(',', array_keys($_POST)),
]);

if ($pollId <= 0) sp_safe_redirect(XOOPS_URL . '/modules/sondages_pro/index.php');

/* PLUS DE CSRF ICI — volontairement désactivé */

/* Handlers */
$pollHandler = xoops_getModuleHandler('poll', 'sondages_pro');
$optHandler  = xoops_getModuleHandler('option', 'sondages_pro');
$voteHandler = xoops_getModuleHandler('vote', 'sondages_pro');
if (!$pollHandler || !$optHandler || !$voteHandler) sp_safe_redirect(XOOPS_URL . '/modules/sondages_pro/index.php');

$poll = $pollHandler->get($pollId);
if (!$poll) sp_safe_redirect(XOOPS_URL . '/modules/sondages_pro/index.php');


if (!sp_userCan('sp_vote')) sp_safe_redirect($viewUrl . '&err=perm');
if (!sp_isPollOpen($poll))  sp_safe_redirect($viewUrl . '&err=window');


$allowGuest  = !empty($GLOBALS['xoopsModuleConfig']['allow_guest']);
$cfgCooldown = (int)($GLOBALS['xoopsModuleConfig']['cooldown_minutes'] ?? 0);
if (!$allowGuest && $cfgCooldown === 0) {
    $mh  = xoops_getHandler('module');
    $cfh = xoops_getHandler('config');
    $mod = $mh ? $mh->getByDirname('sondages_pro') : null;
    if ($mod && $cfh) {
        $cfgs = $cfh->getConfigsByCat(0, (int)$mod->getVar('mid'));
        $allowGuest  = !empty($cfgs['allow_guest']);
        $cfgCooldown = (int)($cfgs['cooldown_minutes'] ?? 0);
    }
}


$uid = is_object($GLOBALS['xoopsUser']) ? (int)$GLOBALS['xoopsUser']->getVar('uid') : 0;
if ($uid === 0 && !$allowGuest) sp_safe_redirect($viewUrl . '&err=perm');

$ip = (class_exists('XoopsUserUtility') && method_exists('XoopsUserUtility','getIP'))
    ? XoopsUserUtility::getIP(false)
    : ($_SERVER['REMOTE_ADDR'] ?? '');
$ip = substr((string)$ip, 0, 45);


$allowed = [];
$criteria = new Criteria('poll_id', $pollId);
$criteria->setSort('sort_order');
foreach ($optHandler->getObjects($criteria) as $o) {
    $allowed[(int)$o->getVar('option_id')] = true;
}
if (empty($allowed)) sp_safe_redirect($viewUrl . '&err=choice');


$isMultiple = (int)$poll->getVar('is_multiple');
$maxChoices = max(1, (int)$poll->getVar('max_choices'));
$selected   = [];

if ($isMultiple) {
    foreach ((array)($_POST['choices'] ?? []) as $oid) {
        $oid = (int)$oid;
        if ($oid > 0 && isset($allowed[$oid])) $selected[$oid] = true;
    }
    if (count($selected) === 0 || count($selected) > $maxChoices) {
        sp_safe_redirect($viewUrl . '&err=choice');
    }
} else {
    $one = (int)($_POST['choice'] ?? 0);
    if ($one <= 0 || !isset($allowed[$one])) {
        sp_safe_redirect($viewUrl . '&err=choice');
    }
    $selected[$one] = true;
}


$lastVoteTs = 0;
if ($uid > 0) {
    $c = new CriteriaCompo(new Criteria('poll_id', $pollId));
    $c->add(new Criteria('uid', $uid));
    $c->setSort('created_at'); $c->setOrder('DESC'); $c->setLimit(1);
    $last = $voteHandler->getObjects($c);
    if (!empty($last)) $lastVoteTs = strtotime((string)$last[0]->getVar('created_at')) ?: 0;
} else {
    $c = new CriteriaCompo(new Criteria('poll_id', $pollId));
    $c->add(new Criteria('uid', 0));
    if ($ip !== '') $c->add(new Criteria('ip', $ip));
    $c->setSort('created_at'); $c->setOrder('DESC'); $c->setLimit(1);
    $last = $voteHandler->getObjects($c);
    if (!empty($last)) $lastVoteTs = strtotime((string)$last[0]->getVar('created_at')) ?: 0;
}

if ($lastVoteTs > 0) {
    if ($cfgCooldown > 0) {
        $remain = ($lastVoteTs + $cfgCooldown * 60) - time();
        if ($remain > 0) sp_safe_redirect($viewUrl . '&err=cooldown');
    } else {
        sp_safe_redirect(XOOPS_URL . '/modules/sondages_pro/results.php?poll_id=' . $pollId . '&ok=1');
    }
}


$now = date('Y-m-d H:i:s');
foreach (array_keys($selected) as $oid) {
    $v = $voteHandler->create();
    $v->setVar('poll_id',    $pollId);
    $v->setVar('option_id',  (int)$oid);
    $v->setVar('uid',        $uid);
    $v->setVar('ip',         $ip);
    $v->setVar('created_at', $now);
    $voteHandler->insert($v);
}

@setcookie('spv_' . $pollId, (string)time(), time() + 365*24*3600, '/');
sp_safe_redirect(XOOPS_URL . '/modules/sondages_pro/results.php?poll_id=' . $pollId . '&ok=1');

