<?php
defined('XOOPS_ROOT_PATH') || exit('Restricted access');

$modversion = [];
$modversion['name']        = _MI_SP_NAME;
$modversion['version']     = '1.1.0';
$modversion['description'] = _MI_SP_DESC;
$modversion['author']      = 'Stéphane + XOOPS';
$modversion['dirname']     = 'sondages_pro';
$modversion['image']       = 'assets/xoops_sondage.png';
$modversion['hasMain']     = 1;

// SQL
$modversion['sqlfile']['mysql'] = 'sql/mysql.sql';
$modversion['tables'] = ['sp_polls','sp_options','sp_votes'];

// Admin
$modversion['hasAdmin']   = 1;
$modversion['adminindex'] = 'admin/index.php';
$modversion['adminmenu']  = 'admin/menu.php';
$modversion['system_menu'] = 1;
$modversion['onInstall'] = 'include/oninstall.php';

// Templates (front)
$modversion['templates'][] = ['file' => 'sondages_pro_index.tpl',   'description' => 'List polls'];
$modversion['templates'][] = ['file' => 'sondages_pro_view.tpl',    'description' => 'Vote form'];
$modversion['templates'][] = ['file' => 'sondages_pro_results.tpl', 'description' => 'Results'];

// Blocks
$modversion['blocks'][] = [
    'file'        => 'sp_block_active.php',
    'name'        => 'Sondage en cours',
    'description' => 'Affiche le(s) sondage(s) actuellement ouverts',
    'show_func'   => 'sp_block_active_show',
    'template'    => 'sondages_pro_block_active.tpl',
];

$modversion['blocks'][] = [
    'file'        => 'sp_block_results.php',
    'name'        => _MI_SP_BLOCK_RESULTS,
    'description' => 'Affiche les derniers sondages fermés',
    'show_func'   => 'sp_block_results_show',
    'edit_func'   => 'sp_block_results_edit',   
    'options'     => '5|1|0',                   
    'template'    => 'sondages_pro_block_results.tpl',
];


$modversion['blocks'][] = [
    'file'        => 'sp_block_results.php',
    'name'        => 'Derniers résultats',
    'description' => 'Affiche les derniers sondages fermés',
    'show_func'   => 'sp_block_results_show',
    'template'    => 'sondages_pro_block_results.tpl',
    'options'     => '5', 
];


// Config
$modversion['config'][] = [
  'name'        => 'allow_guest',
  'title'       => '_MI_SP_ALLOW_GUEST',
  'description' => '_MI_SP_ALLOW_GUEST_DESC',
  'formtype'    => 'yesno',
  'valuetype'   => 'int',
  'default'     => 1
];
$modversion['config'][] = [
  'name'        => 'cooldown_minutes',
  'title'       => '_MI_SP_COOLDOWN',
  'description' => '_MI_SP_COOLDOWN_DESC',
  'formtype'    => 'textbox',
  'valuetype'   => 'int',
  'default'     => 0
];
