<?php
declare(strict_types=1);

require_once dirname(__DIR__, 3) . '/mainfile.php';
require_once XOOPS_ROOT_PATH . '/include/cp_header.php';

xoops_loadLanguage('admin', 'xoopspulse');

$xoopsUser   = $GLOBALS['xoopsUser'] ?? null;
$xoopsModule = $GLOBALS['xoopsModule'] ?? null;

if (!is_object($xoopsModule)) {
    $mh = xoops_getHandler('module');
    $xoopsModule = $mh ? $mh->getByDirname('xoopspulse') : null;
}

if (!is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
    redirect_header(XOOPS_URL . '/', 3, defined('_AM_XOOPSPULSE_NOPERM') ? _AM_XOOPSPULSE_NOPERM : 'Accès refusé');
    exit;
}

$xoopsDB = $GLOBALS['xoopsDB'];
$table   = $xoopsDB->prefix('xoopspulse_hits');

function q1($db, string $sql): int {
    $r = $db->query($sql);
    if (!$r) return 0;
    $row = $db->fetchRow($r);
    return $row ? (int)$row[0] : 0;
}
function topRows($db, string $sql): array {
    $out = [];
    $r = $db->query($sql);
    if (!$r) return $out;
    while ($row = $db->fetchArray($r)) $out[] = $row;
    return $out;
}
function clauseAnd(string $where): string {
    return $where !== '' ? ($where . ' AND ') : 'WHERE ';
}

$range = isset($_GET['range']) ? (string)$_GET['range'] : '24h';
$allowed = ['24h','7d','30d'];
if (!in_array($range, $allowed, true)) $range = '24h';

$now = time();
$since = $now - 86400; // default 24h
if ($range === '7d')  $since = $now - 7*86400;
if ($range === '30d') $since = $now - 30*86400;

$where = "WHERE ts >= " . (int)$since;

// Résumés
$total   = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where");
$uniqIp  = q1($xoopsDB, "SELECT COUNT(DISTINCT ip_anon) FROM $table $where");
$uniqUid = q1($xoopsDB, "SELECT COUNT(DISTINCT uid) FROM $table $where AND uid>0");
$guests  = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where AND uid=0");

$hitsPerIp = ($uniqIp > 0) ? round($total / $uniqIp, 2) : 0.0;

// Tops suspects
$topIp = topRows($xoopsDB, "SELECT ip_anon, COUNT(*) AS c
                            FROM $table $where
                            GROUP BY ip_anon
                            ORDER BY c DESC
                            LIMIT 30");

$topUa = topRows($xoopsDB, "SELECT ua, COUNT(*) AS c
                            FROM $table $where
                            GROUP BY ua
                            ORDER BY c DESC
                            LIMIT 20");

$topUid = topRows($xoopsDB, "SELECT uid, COUNT(*) AS c
                             FROM $table $where
                             GROUP BY uid
                             ORDER BY c DESC
                             LIMIT 20");

$topPages = topRows($xoopsDB, "SELECT page, COUNT(*) AS c
                               FROM $table $where AND page<>''
                               GROUP BY page
                               ORDER BY c DESC
                               LIMIT 30");

// --- Pic horaire (48h) + baseline (moyenne sur 7 jours par heure)
$hours48 = topRows($xoopsDB, "SELECT DATE_FORMAT(FROM_UNIXTIME(ts),'%Y-%m-%d %H:00') AS h,
                                     HOUR(FROM_UNIXTIME(ts)) AS hr,
                                     COUNT(*) AS c
                              FROM $table
                              WHERE ts >= " . (int)($now - 48*3600) . "
                              GROUP BY h, hr
                              ORDER BY h DESC");

$baseline = [];
// baseline sur 7 jours, en excluant les dernières 24h (sinon on fausse)
$baseRows = topRows($xoopsDB, "
    SELECT hr, AVG(cnt) AS avg_c
    FROM (
        SELECT DATE(FROM_UNIXTIME(ts)) AS d,
               HOUR(FROM_UNIXTIME(ts)) AS hr,
               COUNT(*) AS cnt
        FROM $table
        WHERE ts >= " . (int)($now - 7*86400) . "
          AND ts <  " . (int)($now - 86400) . "
        GROUP BY d, hr
    ) t
    GROUP BY hr
");
foreach ($baseRows as $r) {
    $baseline[(int)$r['hr']] = (float)$r['avg_c'];
}

$topUid = topRows($xoopsDB, "
    SELECT h.uid, u.uname, COUNT(*) AS c
    FROM $table h
    LEFT JOIN " . $xoopsDB->prefix('users') . " u ON u.uid = h.uid
    $where
    GROUP BY h.uid, u.uname
    ORDER BY c DESC
    LIMIT 20
");


// Dernière purge + config filtrage
$purgeFile = XOOPS_ROOT_PATH . '/cache/xoopspulse_last_purge.txt';
$lastPurge = is_file($purgeFile) ? (int)@file_get_contents($purgeFile) : 0;

$cfgFile = dirname(__DIR__) . '/include/pulse_config.php';
$cfg = is_file($cfgFile) ? require $cfgFile : [];
$cfg = is_array($cfg) ? $cfg : [];

xoops_cp_header();

echo '<h2>XOOPS Pulse — Anomalies / Sécurité</h2>';

echo '<form method="get" style="margin:10px 0">';
echo '<label>Période : </label> ';
echo '<select name="range" onchange="this.form.submit()">';
$labels = ['24h'=>'24 heures','7d'=>'7 jours','30d'=>'30 jours'];
foreach ($labels as $k=>$label) {
    $sel = ($range === $k) ? ' selected' : '';
    echo '<option value="'.htmlspecialchars($k, ENT_QUOTES).'"'.$sel.'>'.htmlspecialchars($label, ENT_QUOTES).'</option>';
}
echo '</select>';
echo '</form>';

echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Total hits :</b> '.(int)$total.' &nbsp; | &nbsp; ';
echo '<b>IPs uniques :</b> '.(int)$uniqIp.' &nbsp; | &nbsp; ';
echo '<b>Users loggés uniques :</b> '.(int)$uniqUid.' &nbsp; | &nbsp; ';
echo '<b>Invités :</b> '.(int)$guests.'<br>';
echo '<b>Hits/IP :</b> '.$hitsPerIp;
echo '</div>';

echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Alertes rapides :</b><br>';
if ($hitsPerIp >= 20) {
    echo '• ⚠️ Hits/IP élevé ('.$hitsPerIp.') → possible robot/scan ou pages très rechargées.<br>';
} else {
    echo '• ✅ Hits/IP correct ('.$hitsPerIp.').<br>';
}
if ($guests > ($total * 0.95) && $total > 50) {
    echo '• ⚠️ Majorité d’invités → bots possibles (selon ton trafic).<br>';
}
if ($lastPurge > 0) {
    echo '• Dernière purge auto : <b>' . formatTimestamp($lastPurge, 'm') . '</b><br>';
} else {
    echo '• Dernière purge auto : <i>pas encore enregistrée</i><br>';
}
echo '</div>';

// --- Pic horaire
echo '<h3 style="margin-top:18px">Pics horaires (48h) vs moyenne 7 jours</h3>';
echo '<table class="outer" style="width:100%">';
echo '<tr class="head"><th>Heure</th><th>Hits</th><th>Moyenne (7j)</th><th>Ratio</th><th>Statut</th></tr>';

$maxRows = 24; // affiche les 24 dernières heures
$shown = 0;

foreach ($hours48 as $r) {
    if ($shown >= $maxRows) break;

    $h  = (string)$r['h'];
    $hr = (int)$r['hr'];
    $c  = (int)$r['c'];
    $avg = $baseline[$hr] ?? 0.0;

    $ratio = ($avg > 0.0) ? ($c / $avg) : 0.0;

    $status = '—';
    if ($avg > 0.0 && $c >= 20 && $ratio >= 3.0) $status = '⚠️ Pic';
    if ($avg > 0.0 && $c >= 20 && $ratio >= 6.0) $status = '🚨 Fort pic';

    echo '<tr class="even">';
    echo '<td>'.htmlspecialchars($h, ENT_QUOTES).'</td>';
    echo '<td>'.$c.'</td>';
    echo '<td>'.($avg > 0 ? round($avg, 1) : 'n/a').'</td>';
    echo '<td>'.($avg > 0 ? round($ratio, 2) : 'n/a').'</td>';
    echo '<td>'.$status.'</td>';
    echo '</tr>';

    $shown++;
}
echo '</table>';

// Tables “Top …”
$renderTop = function(string $title, array $rows, array $cols) {
    echo '<h3 style="margin-top:18px">'.htmlspecialchars($title, ENT_QUOTES).'</h3>';
    echo '<table class="outer" style="width:100%"><tr class="head">';
    foreach ($cols as $c) echo '<th>'.htmlspecialchars($c, ENT_QUOTES).'</th>';
    echo '</tr>';

    if (!$rows) {
        echo '<tr class="even"><td colspan="'.count($cols).'"><i>Aucune donnée</i></td></tr>';
    } else {
        foreach ($rows as $r) {
            echo '<tr class="even">';
            foreach ($cols as $k => $label) {
                // $k est index 0..n-1 ici, on map via ordre dans $cols plus bas
            }
            echo '</tr>';
        }
    }
    echo '</table>';
};

echo '<h3 style="margin-top:18px">Top IPs anonymisées</h3>';
echo '<table class="outer" style="width:100%"><tr class="head"><th>IP (anon)</th><th>Hits</th><th>Note</th></tr>';
foreach ($topIp as $r) {
    $ip = (string)$r['ip_anon'];
    $c  = (int)$r['c'];
    $note = ($range === '24h' && $c >= 200) ? '⚠️ Très actif' : (($range !== '24h' && $c >= 800) ? '⚠️ Très actif' : '');
    echo '<tr class="even"><td>'.htmlspecialchars($ip, ENT_QUOTES).'</td><td>'.$c.'</td><td>'.$note.'</td></tr>';
}
echo '</table>';

echo '<h3 style="margin-top:18px">Top User-Agents</h3>';
echo '<table class="outer" style="width:100%"><tr class="head"><th>UA</th><th>Hits</th><th>Note</th></tr>';
foreach ($topUa as $r) {
    $ua = (string)$r['ua'];
    $c  = (int)$r['c'];
    $uaShort = (strlen($ua) > 160) ? substr($ua, 0, 160) . '…' : $ua;
    $note = (preg_match('~bot|crawl|spider|slurp|preview|monitor|uptime~i', $ua) ? '🤖 bot ?' : '');
    echo '<tr class="even"><td>'.htmlspecialchars($uaShort, ENT_QUOTES).'</td><td>'.$c.'</td><td>'.$note.'</td></tr>';
}
echo '</table>';

echo '<h3 style="margin-top:18px">Top UIDs</h3>';
echo '<table class="outer" style="width:100%"><tr class="head"><th>UID</th><th>Hits</th></tr>';
foreach ($topUid as $r) {
if($r['uid']=="0")
{
$r['uname']="Anonyme";
}
echo '<tr class="even"><td>' . (int)$r['uid']

   . (!empty($r['uname']) ? ' <span style="color:#666">(' . htmlspecialchars((string)$r['uname'], ENT_QUOTES) . ')</span>' : '')
   . '</td><td>' . (int)$r['c'] . '</td></tr>';

}
echo '</table>';

echo '<h3 style="margin-top:18px">Top pages</h3>';
echo '<table class="outer" style="width:100%"><tr class="head"><th>Page</th><th>Hits</th></tr>';
foreach ($topPages as $r) {
    $p = (string)$r['page'];
    if ($p === '') $p = '(vide)';
    echo '<tr class="even"><td>'.htmlspecialchars($p, ENT_QUOTES).'</td><td>'.(int)$r['c'].'</td></tr>';
}
echo '</table>';

// Config filtrage (lecture seule)
echo '<h3 style="margin-top:18px">Config filtrage (lecture seule)</h3>';
echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Fichier :</b> /modules/xoopspulse/include/pulse_config.php<br><br>';
echo '<pre style="white-space:pre-wrap;margin:0">';
echo htmlspecialchars(print_r($cfg, true), ENT_QUOTES);
echo '</pre>';
echo '</div>';



xoops_cp_footer();

