<?php
declare(strict_types=1);

require_once dirname(__DIR__, 3) . '/mainfile.php';
require_once XOOPS_ROOT_PATH . '/include/cp_header.php';

xoops_loadLanguage('admin', 'xoopspulse');

$xoopsUser   = $GLOBALS['xoopsUser'] ?? null;
$xoopsModule = $GLOBALS['xoopsModule'] ?? null;

if (!is_object($xoopsModule)) {
    $moduleHandler = xoops_getHandler('module');
    $xoopsModule   = $moduleHandler ? $moduleHandler->getByDirname('xoopspulse') : null;
}

if (!is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
    redirect_header(XOOPS_URL . '/', 3, _AM_XOOPSPULSE_NOPERM);
    exit;
}

$xoopsDB = $GLOBALS['xoopsDB'];
$table   = $xoopsDB->prefix('xoopspulse_hits');

$days = isset($_GET['days']) ? (int)$_GET['days'] : 30;
$allowed = [0, 7, 30, 90];
if (!in_array($days, $allowed, true)) $days = 30;

$where = '';
if ($days > 0) {
    $since = time() - ($days * 86400);
    $where = "WHERE ts >= " . (int)$since;
}

function q1($db, string $sql): int {
    $r = $db->query($sql);
    if (!$r) return 0;
    $row = $db->fetchRow($r);
    return $row ? (int)$row[0] : 0;
}

function topRows($db, string $sql): array {
    $out = [];
    $r = $db->query($sql);
    if (!$r) return $out;
    while ($row = $db->fetchArray($r)) $out[] = $row;
    return $out;
}

$total = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where");
$uniqIp = q1($xoopsDB, "SELECT COUNT(DISTINCT ip_anon) FROM $table $where");

$mobileCount = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " is_mobile=1");
$vpKnown = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " vp_w>0");

$mobilePct = ($total > 0) ? round(($mobileCount / $total) * 100, 1) : 0.0;

$smallVp = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " vp_w BETWEEN 1 AND 767");
$smallVpPct = ($vpKnown > 0) ? round(($smallVp / $vpKnown) * 100, 1) : 0.0;

// Tops
$topOs = topRows($xoopsDB, "SELECT os, COUNT(*) AS c FROM $table $where GROUP BY os ORDER BY c DESC LIMIT 10");
$topBr = topRows($xoopsDB, "SELECT browser, COUNT(*) AS c FROM $table $where GROUP BY browser ORDER BY c DESC LIMIT 10");
$topScreen = topRows($xoopsDB, "SELECT CONCAT(screen_w,'×',screen_h) AS r, COUNT(*) AS c
                               FROM $table $where
                               AND screen_w>0 AND screen_h>0
                               GROUP BY r ORDER BY c DESC LIMIT 10");
$topVp = topRows($xoopsDB, "SELECT CONCAT(vp_w,'×',vp_h) AS r, COUNT(*) AS c
                           FROM $table $where
                           AND vp_w>0 AND vp_h>0
                           GROUP BY r ORDER BY c DESC LIMIT 10");

$topTz = topRows($xoopsDB, "SELECT tz, COUNT(*) AS c FROM $table $where AND tz<>'' GROUP BY tz ORDER BY c DESC LIMIT 10");

xoops_cp_header();

echo '<h2>XOOPS Pulse — Dashboard</h2>';

echo '<form method="get" style="margin:10px 0">';
echo '<label>Période : </label> ';
echo '<select name="days" onchange="this.form.submit()">';
foreach ([0=>'Tout', 7=>'7 jours', 30=>'30 jours', 90=>'90 jours'] as $k=>$label) {
    $sel = ($days === (int)$k) ? ' selected' : '';
    echo '<option value="'.(int)$k.'"'.$sel.'>'.htmlspecialchars($label, ENT_QUOTES).'</option>';
}
echo '</select>';
echo '</form>';

echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Total hits :</b> ' . (int)$total . ' &nbsp; | &nbsp; ';

echo '<b>IPs anonymisées uniques :</b> ' . (int)$uniqIp . ' &nbsp; | &nbsp; ';
echo '<b>Mobile :</b> ' . $mobilePct . '%';
echo '</div>';
echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Maintenance :</b> ';
echo '<a class="button" href="purge.php">Purge / Rétention</a>';
echo '</div>';

// Recos simples
echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Recommandations :</b><br>';
if ($mobilePct >= 50) {
    echo '• Audience majoritairement mobile → privilégier un design “mobile-first”.<br>';
}
if ($smallVpPct >= 30) {
    echo '• ' . $smallVpPct . '% des viewports sont &lt; 768px → surveiller les débordements CSS et menus responsive.<br>';
}
if ($mobilePct < 20) {
    echo '• Audience surtout desktop → optimiser aussi la lisibilité sur grands écrans (largeurs max, colonnes).<br>';
}
echo '</div>';

function renderTopTable(string $title, array $rows, string $k1, string $k2): void {
    echo '<h3 style="margin-top:18px">'.htmlspecialchars($title, ENT_QUOTES).'</h3>';
    echo '<table class="outer" style="width:100%">';
    echo '<tr class="head"><th>Valeur</th><th>Nombre</th></tr>';
    if (!$rows) {
        echo '<tr class="even"><td colspan="2"><i>Aucune donnée</i></td></tr>';
    } else {
        foreach ($rows as $r) {
            $v = (string)($r[$k1] ?? '');
            $c = (int)($r[$k2] ?? 0);
            if ($v === '') $v = '(vide)';
            echo '<tr class="even"><td>'.htmlspecialchars($v, ENT_QUOTES).'</td><td>'.$c.'</td></tr>';
        }
    }
    echo '</table>';
}

renderTopTable('Top OS', $topOs, 'os', 'c');
renderTopTable('Top Navigateurs', $topBr, 'browser', 'c');
renderTopTable('Top Résolutions écran', $topScreen, 'r', 'c');
renderTopTable('Top Viewports', $topVp, 'r', 'c');
renderTopTable('Top Timezones', $topTz, 'tz', 'c');

// Derniers hits
echo '<h3 style="margin-top:18px">' . _AM_XOOPSPULSE_LAST_HITS . '</h3>';

$res = $xoopsDB->query("
    SELECT h.id, h.ts, h.uid, u.uname, h.ip_anon, h.os, h.browser, h.is_mobile,
           h.screen_w, h.screen_h, h.vp_w, h.vp_h, h.dpr, h.lang, h.tz, h.darkmode, h.page
    FROM $table h
    LEFT JOIN " . $xoopsDB->prefix('users') . " u ON u.uid = h.uid
    ORDER BY h.id DESC
    LIMIT 50
");


echo '<table class="outer" style="width:100%">';
echo '<tr class="head">
        <th>ID</th><th>Date</th><th>UID</th><th>IP (anon)</th><th>OS</th><th>Navigateur</th>
        <th>Mobile</th><th>Screen</th><th>Viewport</th><th>DPR</th><th>Lang</th><th>TZ</th><th>Dark</th><th>Page</th>
      </tr>';

while ($row = $xoopsDB->fetchArray($res)) {
    echo '<tr class="even">';
    echo '<td>' . (int)$row['id'] . '</td>';
    echo '<td>' . formatTimestamp((int)$row['ts'], 'm') . '</td>';
$uname = isset($row['uname']) ? (string)$row['uname'] : '';
echo '<td>' . (int)$row['uid']
   . ($uname !== '' ? ' <span style="color:#666">(' . htmlspecialchars($uname, ENT_QUOTES) . ')</span>' : '')
   . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['ip_anon'], ENT_QUOTES) . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['os'], ENT_QUOTES) . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['browser'], ENT_QUOTES) . '</td>';
    echo '<td>' . ((int)$row['is_mobile'] ? 'Oui' : 'Non') . '</td>';
    echo '<td>' . (int)$row['screen_w'] . '×' . (int)$row['screen_h'] . '</td>';
    echo '<td>' . (int)$row['vp_w'] . '×' . (int)$row['vp_h'] . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['dpr'], ENT_QUOTES) . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['lang'], ENT_QUOTES) . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['tz'], ENT_QUOTES) . '</td>';
    echo '<td>' . ((int)$row['darkmode'] ? 'Oui' : 'Non') . '</td>';
    echo '<td>' . htmlspecialchars((string)$row['page'], ENT_QUOTES) . '</td>';
    echo '</tr>';
}
echo '</table>';

xoops_cp_footer();

