<?php
declare(strict_types=1);

require_once dirname(__DIR__, 3) . '/mainfile.php';
require_once XOOPS_ROOT_PATH . '/include/cp_header.php';

xoops_loadLanguage('admin', 'xoopspulse');

$xoopsUser   = $GLOBALS['xoopsUser'] ?? null;
$xoopsModule = $GLOBALS['xoopsModule'] ?? null;

if (!is_object($xoopsModule)) {
    $mh = xoops_getHandler('module');
    $xoopsModule = $mh ? $mh->getByDirname('xoopspulse') : null;
}

if (!is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
    redirect_header(XOOPS_URL . '/', 3, _AM_XOOPSPULSE_NOPERM);
    exit;
}

$xoopsDB = $GLOBALS['xoopsDB'];
$table   = $xoopsDB->prefix('xoopspulse_hits');

$days = isset($_GET['days']) ? (int)$_GET['days'] : 30;
$allowed = [0, 7, 30, 90];
if (!in_array($days, $allowed, true)) $days = 30;

$where = '';
if ($days > 0) {
    $since = time() - ($days * 86400);
    $where = "WHERE ts >= " . (int)$since;
}

function q1($db, string $sql): int {
    $r = $db->query($sql);
    if (!$r) return 0;
    $row = $db->fetchRow($r);
    return $row ? (int)$row[0] : 0;
}

function qf($db, string $sql): float {
    $r = $db->query($sql);
    if (!$r) return 0.0;
    $row = $db->fetchRow($r);
    return $row ? (float)$row[0] : 0.0;
}

function topRows($db, string $sql): array {
    $out = [];
    $r = $db->query($sql);
    if (!$r) return $out;
    while ($row = $db->fetchArray($r)) $out[] = $row;
    return $out;
}

$total = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where");
$uniqIp = q1($xoopsDB, "SELECT COUNT(DISTINCT ip_anon) FROM $table $where");
$uniqUid = q1($xoopsDB, "SELECT COUNT(DISTINCT uid) FROM $table $where AND uid>0");

$mobile = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " is_mobile=1");
$dark   = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " darkmode=1");

$knownVp = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " vp_w>0");
$smallVp = q1($xoopsDB, "SELECT COUNT(*) FROM $table $where " . ($where ? "AND" : "WHERE") . " vp_w BETWEEN 1 AND 767");

$mobilePct = $total ? round(($mobile / $total) * 100, 1) : 0.0;
$darkPct   = $total ? round(($dark / $total) * 100, 1) : 0.0;
$smallVpPct= $knownVp ? round(($smallVp / $knownVp) * 100, 1) : 0.0;

$topOs = topRows($xoopsDB, "SELECT os, COUNT(*) AS c FROM $table $where GROUP BY os ORDER BY c DESC LIMIT 5");
$topBr = topRows($xoopsDB, "SELECT browser, COUNT(*) AS c FROM $table $where GROUP BY browser ORDER BY c DESC LIMIT 5");
$topVp = topRows($xoopsDB, "SELECT CONCAT(vp_w,'×',vp_h) AS r, COUNT(*) AS c
                            FROM $table $where AND vp_w>0 AND vp_h>0
                            GROUP BY r ORDER BY c DESC LIMIT 5");
$topPages = topRows($xoopsDB, "SELECT page, COUNT(*) AS c
                               FROM $table $where AND page<>'' GROUP BY page ORDER BY c DESC LIMIT 8");

xoops_cp_header();

echo '<h2>XOOPS Pulse — Insights</h2>';

echo '<form method="get" style="margin:10px 0">';
echo '<label>Période : </label> ';
echo '<select name="days" onchange="this.form.submit()">';
foreach ([0=>'Tout', 7=>'7 jours', 30=>'30 jours', 90=>'90 jours'] as $k=>$label) {
    $sel = ($days === (int)$k) ? ' selected' : '';
    echo '<option value="'.(int)$k.'"'.$sel.'>'.htmlspecialchars($label, ENT_QUOTES).'</option>';
}
echo '</select>';
echo '</form>';

echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Total hits :</b> '.(int)$total.' &nbsp; | &nbsp; ';
echo '<b>IPs uniques :</b> '.(int)$uniqIp.' &nbsp; | &nbsp; ';
echo '<b>Users loggés uniques :</b> '.(int)$uniqUid.'<br>';
echo '<b>Mobile :</b> '.$mobilePct.'% &nbsp; | &nbsp; ';
echo '<b>Dark mode :</b> '.$darkPct.'% &nbsp; | &nbsp; ';
echo '<b>Viewports < 768px :</b> '.$smallVpPct.'%';
echo '</div>';

echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo '<b>Conclusions / actions :</b><br>';

if ($mobilePct >= 50) {
    echo '• Audience majoritairement <b>mobile</b> → UI mobile-first, menus/boutons plus grands, éviter les hover-only.<br>';
} else {
    echo '• Audience plutôt <b>desktop</b> → optimiser la lecture sur large écran (max-width, colonnes, spacing).<br>';
}

if ($smallVpPct >= 30) {
    echo '• Beaucoup de <b>petits viewports</b> → vérifier débordements CSS, tableaux, modales, et menus responsive.<br>';
}

if ($darkPct >= 25) {
    echo '• Dark mode fréquent → vérifier contraste, icônes, images (fonds transparents).<br>';
}

if ($uniqIp > 0 && $total > 0) {
    $hitsPerIp = round($total / max(1, $uniqIp), 2);
    echo '• <b>Hits/IP</b> ≈ '.$hitsPerIp.' → utile pour estimer engagement/navigation.<br>';
}

echo '</div>';

$renderSmall = function(string $title, array $rows, string $kVal, string $kCnt) {
    echo '<h3 style="margin-top:18px">'.htmlspecialchars($title, ENT_QUOTES).'</h3>';
    echo '<table class="outer" style="width:100%"><tr class="head"><th>Valeur</th><th>Nombre</th></tr>';
    if (!$rows) {
        echo '<tr class="even"><td colspan="2"><i>Aucune donnée</i></td></tr>';
    } else {
        foreach ($rows as $r) {
            $v = (string)($r[$kVal] ?? '');
            $c = (int)($r[$kCnt] ?? 0);
            if ($v === '') $v = '(vide)';
            echo '<tr class="even"><td>'.htmlspecialchars($v, ENT_QUOTES).'</td><td>'.$c.'</td></tr>';
        }
    }
    echo '</table>';
};

$renderSmall('Top OS', $topOs, 'os', 'c');
$renderSmall('Top Navigateurs', $topBr, 'browser', 'c');
$renderSmall('Top Viewports', $topVp, 'r', 'c');
$renderSmall('Top Pages', $topPages, 'page', 'c');



xoops_cp_footer();

