<?php
declare(strict_types=1);

require_once dirname(__DIR__, 3) . '/mainfile.php';
require_once XOOPS_ROOT_PATH . '/include/cp_header.php';

xoops_loadLanguage('admin', 'xoopspulse');

$xoopsUser   = $GLOBALS['xoopsUser'] ?? null;
$xoopsModule = $GLOBALS['xoopsModule'] ?? null;

if (!is_object($xoopsModule)) {
    $mh = xoops_getHandler('module');
    $xoopsModule = $mh ? $mh->getByDirname('xoopspulse') : null;
}

if (!is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
    redirect_header(XOOPS_URL . '/', 3, _AM_XOOPSPULSE_NOPERM);
    exit;
}

$xoopsDB = $GLOBALS['xoopsDB'];
$table   = $xoopsDB->prefix('xoopspulse_hits');

$days = isset($_GET['days']) ? (int)$_GET['days'] : 30;
$allowed = [0, 7, 30, 90];
if (!in_array($days, $allowed, true)) $days = 30;

$where = '';
if ($days > 0) {
    $since = time() - ($days * 86400);
    $where = "WHERE ts >= " . (int)$since;
}

$filter = isset($_GET['q']) ? trim((string)$_GET['q']) : '';
$filterSql = '';
if ($filter !== '') {
    $safe = $xoopsDB->escape($filter);
    $filterSql = " AND page LIKE '%$safe%'";
}

function topRows($db, string $sql): array {
    $out = [];
    $r = $db->query($sql);
    if (!$r) return $out;
    while ($row = $db->fetchArray($r)) $out[] = $row;
    return $out;
}

$topAll = topRows($xoopsDB, "SELECT page, COUNT(*) AS c
                             FROM $table $where AND page<>'' $filterSql
                             GROUP BY page ORDER BY c DESC LIMIT 50");

$topMobile = topRows($xoopsDB, "SELECT page, COUNT(*) AS c
                                FROM $table $where AND page<>'' AND is_mobile=1 $filterSql
                                GROUP BY page ORDER BY c DESC LIMIT 30");

$topDesktop = topRows($xoopsDB, "SELECT page, COUNT(*) AS c
                                 FROM $table $where AND page<>'' AND is_mobile=0 $filterSql
                                 GROUP BY page ORDER BY c DESC LIMIT 30");

xoops_cp_header();

echo '<h2>XOOPS Pulse — Heatmap pages</h2>';

echo '<form method="get" style="margin:10px 0;display:flex;gap:10px;align-items:center;flex-wrap:wrap">';
echo '<label>Période : </label> ';
echo '<select name="days">';
foreach ([0=>'Tout', 7=>'7 jours', 30=>'30 jours', 90=>'90 jours'] as $k=>$label) {
    $sel = ($days === (int)$k) ? ' selected' : '';
    echo '<option value="'.(int)$k.'"'.$sel.'>'.htmlspecialchars($label, ENT_QUOTES).'</option>';
}
echo '</select>';
echo '<label>Filtre page :</label> ';
echo '<input type="text" name="q" value="'.htmlspecialchars($filter, ENT_QUOTES).'" placeholder="/about.php" style="width:260px">';
echo '<input class="formButton" type="submit" value="Appliquer">';
echo '</form>';

$render = function(string $title, array $rows): void {
    echo '<h3 style="margin-top:18px">'.htmlspecialchars($title, ENT_QUOTES).'</h3>';
    echo '<table class="outer" style="width:100%">';
    echo '<tr class="head"><th>Page</th><th>Hits</th></tr>';
    if (!$rows) {
        echo '<tr class="even"><td colspan="2"><i>Aucune donnée</i></td></tr>';
    } else {
        foreach ($rows as $r) {
            $p = (string)($r['page'] ?? '');
            $c = (int)($r['c'] ?? 0);
            if ($p === '') $p = '(vide)';
            echo '<tr class="even"><td>'.htmlspecialchars($p, ENT_QUOTES).'</td><td>'.$c.'</td></tr>';
        }
    }
    echo '</table>';
};

$render('Top pages (global)', $topAll);
$render('Top pages (mobile)', $topMobile);
$render('Top pages (desktop)', $topDesktop);


xoops_cp_footer();

