<?php
declare(strict_types=1);

require_once dirname(__DIR__, 3) . '/mainfile.php';
require_once XOOPS_ROOT_PATH . '/include/cp_header.php';

xoops_loadLanguage('admin', 'xoopspulse');

$xoopsUser   = $GLOBALS['xoopsUser'] ?? null;
$xoopsModule = $GLOBALS['xoopsModule'] ?? null;

if (!is_object($xoopsModule)) {
    $moduleHandler = xoops_getHandler('module');
    $xoopsModule   = $moduleHandler ? $moduleHandler->getByDirname('xoopspulse') : null;
}

if (!is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
    redirect_header(XOOPS_URL . '/', 3, defined('_AM_XOOPSPULSE_NOPERM') ? _AM_XOOPSPULSE_NOPERM : 'Accès refusé');
    exit;
}

$xoopsDB = $GLOBALS['xoopsDB'];
$table   = $xoopsDB->prefix('xoopspulse_hits');

$days = isset($_POST['retention_days']) ? (int)$_POST['retention_days'] : (isset($_GET['retention_days']) ? (int)$_GET['retention_days'] : 90);
if ($days < 1) $days = 1;
if ($days > 3650) $days = 3650;

$doPurge = isset($_POST['do_purge']) && (int)$_POST['do_purge'] === 1;

xoops_cp_header();

echo '<h2>XOOPS Pulse — Purge</h2>';

echo '<div class="outer" style="padding:10px;margin:10px 0">';
echo 'Cette page permet de supprimer les enregistrements plus anciens que la rétention choisie.';
echo '</div>';

if ($doPurge) {
    // CSRF
    $sec = $GLOBALS['xoopsSecurity'] ?? null;
    if (is_object($sec) && !$sec->check()) {
        echo '<div class="errorMsg">Erreur sécurité (token). Merci de réessayer.</div>';
    } else {
        $threshold = time() - ($days * 86400);

        // Compte avant suppression
        $count = 0;
        $r = $xoopsDB->query("SELECT COUNT(*) FROM $table WHERE ts < " . (int)$threshold);
        if ($r) {
            $row = $xoopsDB->fetchRow($r);
            $count = $row ? (int)$row[0] : 0;
        }

        $ok = $xoopsDB->queryF("DELETE FROM $table WHERE ts < " . (int)$threshold);

        echo '<div class="resultMsg" style="padding:10px;margin:10px 0">';
        if ($ok) {
            echo '✅ Purge effectuée : <b>' . $count . '</b> ligne(s) supprimée(s) (plus anciennes que <b>' . (int)$days . '</b> jour(s)).';
        } else {
            echo '❌ Erreur lors de la suppression.';
        }
        echo '</div>';


        $xoopsDB->queryF("OPTIMIZE TABLE $table");
    }
}

echo '<form method="post" style="margin:10px 0">';
echo '<div class="outer" style="padding:10px">';
echo '<label><b>Rétention (jours) :</b></label> ';
echo '<input type="number" name="retention_days" min="1" max="3650" value="' . (int)$days . '" style="width:120px"> ';
echo '<input type="hidden" name="do_purge" value="1"> ';
if (isset($GLOBALS['xoopsSecurity']) && is_object($GLOBALS['xoopsSecurity'])) {
    echo $GLOBALS['xoopsSecurity']->getTokenHTML();
}
echo '<input class="formButton" type="submit" value="Purger maintenant" onclick="return confirm(\'Supprimer les enregistrements plus anciens que ' . (int)$days . ' jours ?\');">';
echo '</div>';
echo '</form>';



xoops_cp_footer();

