<?php
defined('XOOPS_ROOT_PATH') || exit('XOOPS root path not defined');

class XoopspulseCorePreload extends XoopsPreloadItem
{
    public function eventCoreHeaderAddmeta($args)
    {
        if (defined('XOOPS_IN_ADMIN')) {
            return;
        }
        if (!isset($GLOBALS['xoTheme']) || !is_object($GLOBALS['xoTheme'])) {
            return;
        }

        $uid = 0;
        if (isset($GLOBALS['xoopsUser']) && is_object($GLOBALS['xoopsUser'])) {
            $uid = (int)$GLOBALS['xoopsUser']->getVar('uid');
        }

        // UID en inline (fiable)
        $GLOBALS['xoTheme']->addScript(null, null, 'window.__XOOPSPULSE_UID = ' . $uid . ';', null);

        // Cache-busting sur pulse.js
        $jsFile = XOOPS_ROOT_PATH . '/modules/xoopspulse/assets/pulse.js';
        $v = is_file($jsFile) ? (string)filemtime($jsFile) : (string)time();
        $GLOBALS['xoTheme']->addScript(XOOPS_URL . '/modules/xoopspulse/assets/pulse.js?v=' . $v);
    }
}

