// chartjs-overrides.js
(() => {
  if (!window.Chart) return;

  const Chart = window.Chart;

  // ✅ Comportement global (pour TOUS les charts)
  Chart.defaults.responsive = true;
  Chart.defaults.maintainAspectRatio = false; // important si tu fixes la hauteur en CSS
  Chart.defaults.animation = { duration: 0 }; // ou false
  Chart.defaults.plugins.legend.position = "bottom";
  Chart.defaults.plugins.tooltip.enabled = true;

  // (optionnel) Police / couleur globale
  Chart.defaults.color = "#444";
  Chart.defaults.font.family = "Arial, sans-serif";
  Chart.defaults.font.size = 12;

  // ✅ Exemple: tooltip "value + %"
  Chart.defaults.plugins.tooltip.callbacks.label = (ctx) => {
    const label = ctx.label ?? "";
    const raw = ctx.raw ?? 0;

    // total dataset (utile pie/doughnut)
    const data = ctx.dataset.data || [];
    const total = data.reduce((sum, v) => sum + (Number(v) || 0), 0);
    const pct = total ? Math.round((raw / total) * 100) : 0;

    return `${label}: ${raw} (${pct}%)`;
  };
})();

