(() => {
  try {
    // 1 envoi par onglet toutes les 60s
    const KEY = "xoopspulse_last_send";
    const now = Date.now();
    const last = parseInt(sessionStorage.getItem(KEY) || "0", 10);
    if (!Number.isNaN(last) && now - last < 60000) return;
    sessionStorage.setItem(KEY, String(now));

    const scr = window.screen || {};
    const dpr = (typeof window.devicePixelRatio === "number") ? window.devicePixelRatio : 1;

    // base64url helpers
    const b64urlToB64 = (s) => s.replace(/-/g, "+").replace(/_/g, "/") + "===".slice((s.length + 3) % 4);
    const safeAtobJson = (b64url) => {
      try {
        const json = atob(b64urlToB64(b64url));
        return JSON.parse(json);
      } catch (e) {
        return null;
      }
    };

    // Cherche le cookie xoops_user_* (JWT), récupère uid dans le payload
    const uidFromCookie = () => {
      try {
        const m = document.cookie.match(/(?:^|;\s*)(xoops_user_[^=]+)=([^;]+)/);
        if (!m) return 0;
        const token = decodeURIComponent(m[2] || "");
        const parts = token.split(".");
        if (parts.length < 2) return 0;
        const payload = safeAtobJson(parts[1]);
        const uid = payload && (payload.uid ?? payload.user_id ?? payload.sub);
        const n = parseInt(uid, 10);
        return Number.isFinite(n) && n > 0 ? n : 0;
      } catch (e) {
        return 0;
      }
    };

    // UID: d'abord variable globale si dispo, sinon cookie JWT
    let uid = (typeof window.__XOOPSPULSE_UID === "number") ? window.__XOOPSPULSE_UID : 0;
    if (!uid) uid = uidFromCookie();

    // base64url (sans / ni + ni =)
    const b64url = (s) => {
      try {
        return btoa(unescape(encodeURIComponent(s)))
          .replace(/\+/g, "-")
          .replace(/\//g, "_")
          .replace(/=+$/g, "");
      } catch (e) {
        return "";
      }
    };

    let tz = "";
    try {
      tz = Intl.DateTimeFormat().resolvedOptions().timeZone || "";
    } catch (e) {}

    const payload = {
      u: String(uid),
      sw: String((typeof scr.width === "number") ? scr.width : 0),
      sh: String((typeof scr.height === "number") ? scr.height : 0),
      vw: String((typeof window.innerWidth === "number") ? window.innerWidth : 0),
      vh: String((typeof window.innerHeight === "number") ? window.innerHeight : 0),
      dpr100: String(Math.round(dpr * 100)),
      dm: (typeof window.matchMedia === "function" && window.matchMedia("(prefers-color-scheme: dark)").matches) ? "1" : "0",
      lg: (navigator && navigator.language ? navigator.language : "").slice(0, 10),
      tzb: b64url(tz).slice(0, 120),
      pixel: "1",
      t: String(Date.now())
    };

    const url = "/modules/xoopspulse/collect.php";
    const qs = new URLSearchParams(payload).toString();

    // petit délai = évite certains 0×0 sur Chrome
    setTimeout(() => {
      const img = new Image();
      img.src = url + "?" + qs;
    }, 500);

  } catch (e) {}
})();

