<?php
declare(strict_types=1);


return [
    // Exclure bots/robots
    'ignore_bots' => true,

    // Bot regex (large)
    'bot_regex' => '~bot|crawl|spider|slurp|bingpreview|duckduckbot|baiduspider|yandex|mj12bot|semrush|ahrefs|facebookexternalhit|preview|uptimerobot|pingdom|datadog|newrelic|monitor~i',

    // Exclure IP (exact) ou CIDR (IPv4/IPv6)
    // Exemple utile : ton serveur avait 54.37.80.x → on l'exclut
    'ignore_ips' => [
        '127.0.0.1',
        '::1',
        '54.37.80.0/24',
    ],

    // Whitelist IP : si une IP est ici, elle est toujours acceptée (même si bot)
    'allow_ips' => [
        // '82.67.47.0/24',
    ],

    // Exclure certains UID si besoin (ex: comptes techniques)
    'ignore_uids' => [
        // 3,
    ],

    // Enregistrer quand même les hits anonymes ? (si false, on ignore uid=0)
    'allow_guests' => true,
];

